/*
 * Decompiled with CFR 0.152.
 */
package com.client.definitions.anims.decoder.impl;

import com.client.InputBuffer;
import com.client.definitions.SeqDefinition;
import com.client.definitions.anims.decoder.Decoder;
import java.util.Arrays;

public class SeqDefinitionDecoderOSRS
implements Decoder<SeqDefinition> {
    @Override
    public void decode(InputBuffer buffer, SeqDefinition definition) {
        int opcode;
        block20: while ((opcode = buffer.readUnsignedByte()) != 0) {
            switch (opcode) {
                case 1: {
                    int index;
                    int frameCount = buffer.readUnsignedShort();
                    definition.setFrameCount(frameCount);
                    int[] delays = new int[frameCount];
                    int[] primaryFrameIds = new int[frameCount];
                    int[] secondaryFrameIds = new int[frameCount];
                    Arrays.fill(secondaryFrameIds, -1);
                    for (index = 0; index < frameCount; ++index) {
                        delays[index] = buffer.readUnsignedShort();
                    }
                    for (index = 0; index < frameCount; ++index) {
                        primaryFrameIds[index] = buffer.readUnsignedShort();
                    }
                    index = 0;
                    while (index < frameCount) {
                        int n = index++;
                        primaryFrameIds[n] = primaryFrameIds[n] + (buffer.readUnsignedShort() << 16);
                    }
                    definition.setDelays(delays);
                    definition.setFrameIDs(primaryFrameIds);
                    definition.setSecondaryFrameIds(secondaryFrameIds);
                    break;
                }
                case 2: {
                    definition.setFrameStep(buffer.readUnsignedShort());
                    break;
                }
                case 3: {
                    int count2 = buffer.readUnsignedByte();
                    int[] masks = new int[count2 + 1];
                    boolean[] booleanMasks = new boolean[256];
                    for (int i = 0; i < count2; ++i) {
                        masks[i] = buffer.readUnsignedByte();
                        booleanMasks[masks[i]] = true;
                    }
                    masks[count2] = 9999999;
                    definition.setMasks(masks);
                    definition.setBooleanMasks(booleanMasks);
                    break;
                }
                case 4: {
                    definition.setStretches(true);
                    break;
                }
                case 5: {
                    definition.setForcedPriority(buffer.readUnsignedByte());
                    break;
                }
                case 6: {
                    definition.setLeftHandItem(buffer.readUnsignedShort());
                    break;
                }
                case 7: {
                    definition.setRightHandItem(buffer.readUnsignedShort());
                    break;
                }
                case 8: {
                    definition.setLoopCount(buffer.readUnsignedByte());
                    break;
                }
                case 9: {
                    definition.setMoveStyle(buffer.readUnsignedByte());
                    break;
                }
                case 10: {
                    definition.setIdleStyle(buffer.readUnsignedByte());
                    break;
                }
                case 11: {
                    definition.setReplyMode(buffer.readUnsignedByte());
                    break;
                }
                case 12: {
                    int i;
                    int count2 = buffer.readUnsignedByte();
                    int[] chatFrameIds = new int[count2];
                    for (i = 0; i < count2; ++i) {
                        chatFrameIds[i] = buffer.readUnsignedShort();
                    }
                    i = 0;
                    while (i < count2) {
                        int n = i++;
                        chatFrameIds[n] = chatFrameIds[n] + (buffer.readUnsignedShort() << 16);
                    }
                    definition.setChatFrameIds(chatFrameIds);
                    break;
                }
                case 13: {
                    definition.setSkeletalId(buffer.readInt());
                    break;
                }
                case 14: {
                    int index;
                    int count2 = buffer.readUnsignedShort();
                    for (int i = 0; i < count2; ++i) {
                        index = buffer.readUnsignedShort();
                        int id = buffer.readUnsignedShort();
                        int weight = buffer.readUnsignedByte();
                        int loops = buffer.readUnsignedByte();
                        int location = buffer.readUnsignedByte();
                        int retain = buffer.readUnsignedByte();
                        if (id >= 1 && loops >= 1 && location >= 0 && retain < 0) continue;
                    }
                    continue block20;
                }
                case 15: {
                    definition.setRangeBegin(buffer.readUnsignedShort());
                    definition.setRangeEnd(buffer.readUnsignedShort());
                    break;
                }
                case 16: {
                    break;
                }
                case 17: {
                    int index;
                    boolean[] bMasks = new boolean[256];
                    int count2 = buffer.readUnsignedByte();
                    for (index = 0; index < count2; ++index) {
                        bMasks[buffer.readUnsignedByte()] = true;
                    }
                    definition.setBooleanMasks(bMasks);
                    break;
                }
                case 18: {
                    buffer.readStringOSRS();
                }
            }
        }
    }
}

