/*
 * Decompiled with CFR 0.152.
 */
package com.client.definitions;

import com.client.Buffer;
import com.client.FileArchive;

public final class VarBit {
    private static final int[] MASK_LOOKUP = new int[32];
    public int anInt648;
    public int anInt649;
    public int anInt650;
    public static VarBit[] cache;
    private int configID;
    private int leastSignificantBit;
    private int mostSignificantBit;

    public static void unpackConfig(FileArchive streamLoader) {
        Buffer stream = new Buffer(streamLoader.readFile("varbit.dat"));
        int cacheSize = stream.readUShort();
        if (cache == null) {
            cache = new VarBit[cacheSize];
        }
        for (int j = 0; j < cacheSize; ++j) {
            if (cache[j] == null) {
                VarBit.cache[j] = new VarBit();
            }
            cache[j].decode(stream);
        }
        if (stream.currentPosition != stream.payload.length) {
            System.out.println("VarBit load mismatch!");
        }
        System.out.println("Finished loading varbits");
    }

    private void decode(Buffer buffer) {
        int opcode = buffer.readUnsignedByte();
        if (opcode == 0) {
            return;
        }
        if (opcode == 1) {
            this.configID = buffer.readUShort();
            this.leastSignificantBit = buffer.readUnsignedByte();
            this.mostSignificantBit = buffer.readUnsignedByte();
        } else {
            System.out.println("Invalid varbit opcode: " + opcode);
        }
    }

    public int getConfigID() {
        return this.configID;
    }

    public int getLeastSignificantBit() {
        return this.leastSignificantBit;
    }

    public int getMostSignificantBit() {
        return this.mostSignificantBit;
    }

    public static int getBitValue(int id, int[] values2) {
        VarBit defs = VarBit.get(id);
        if (defs == null) {
            return 0;
        }
        int baseVarValue = values2[defs.getConfigID()];
        int numberOfBits = defs.getMostSignificantBit() - defs.getLeastSignificantBit();
        int mask = MASK_LOOKUP[numberOfBits];
        return baseVarValue >> defs.getLeastSignificantBit() & mask;
    }

    public static int setBit(int id, int value, int[] values2) {
        VarBit defs = VarBit.get(id);
        if (defs == null || id == -1) {
            return 0;
        }
        int mask = MASK_LOOKUP[defs.getMostSignificantBit() - defs.getLeastSignificantBit()];
        if (value < 0 || value > mask) {
            value = 0;
        }
        int varpValue = values2[defs.getConfigID()] & ~(mask <<= defs.getLeastSignificantBit()) | value << defs.getLeastSignificantBit() & mask;
        return varpValue;
    }

    public static VarBit get(int id) {
        if (id < 0 || id >= cache.length || cache[id] == null) {
            return null;
        }
        return cache[id];
    }

    private VarBit() {
    }

    static {
        int i = 2;
        for (int i2 = 0; i2 < 32; ++i2) {
            VarBit.MASK_LOOKUP[i2] = i - 1;
            i <<= 1;
        }
    }
}

