/*
 * Decompiled with CFR 0.152.
 */
package com.client.definitions;

import com.client.Buffer;
import com.client.Configuration;
import com.client.FileArchive;
import com.client.Model;
import com.client.ReferenceCache;
import com.client.definitions.SeqDefinition;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Arrays;

public final class GraphicsDefinition {
    public short[] textureReplace;
    public short[] textureFind;
    public final int anInt400;
    public static GraphicsDefinition[] cache;
    public int id;
    private int modelId;
    public int animationId = -1;
    public SeqDefinition animationSequence;
    public int[] recolorToFind = new int[6];
    public int[] recolorToReplace = new int[6];
    public int resizeXY = 128;
    public int resizeZ = 128;
    public int rotation;
    public int modelBrightness;
    public int modelShadow;
    public static ReferenceCache aMRUNodes_415;

    public static void unpackConfig(FileArchive streamLoader) {
        Buffer stream = new Buffer(streamLoader.readFile("spotanim.dat"));
        int length = stream.readUShort();
        if (cache == null) {
            cache = new GraphicsDefinition[length + 15000];
        }
        for (int j = 0; j < length; ++j) {
            if (cache[j] == null) {
                GraphicsDefinition.cache[j] = new GraphicsDefinition();
            }
            if (j == 65535) {
                j = -1;
            }
            GraphicsDefinition.cache[j].id = j;
            cache[j].setDefault();
            cache[j].readValues(stream);
        }
        GraphicsDefinition.cache[2222] = new GraphicsDefinition();
        GraphicsDefinition.cache[2222].id = 2222;
        GraphicsDefinition.cache[2222].modelId = 45299;
        GraphicsDefinition.cache[2222].animationId = 1229;
        GraphicsDefinition.cache[2222].animationSequence = SeqDefinition.get(1229);
        GraphicsDefinition.cache[2267] = new GraphicsDefinition();
        GraphicsDefinition.cache[2267].id = 2267;
        GraphicsDefinition.cache[2267].modelId = 60036;
        GraphicsDefinition.cache[2267].animationId = 328;
        GraphicsDefinition.cache[2267].animationSequence = SeqDefinition.get(GraphicsDefinition.cache[2267].animationId);
        if (Configuration.dumpDataLists) {
            GraphicsDefinition.gfxDump();
        }
    }

    public static void gfxDump() {
        try {
            BufferedWriter fw = new BufferedWriter(new FileWriter("./temp/gfx_list.txt"));
            for (int i = 0; i < cache.length; ++i) {
                GraphicsDefinition item = cache[i];
                if (item == null) continue;
                fw.write("case " + i + ":");
                fw.write(System.getProperty("line.separator"));
                fw.write("gfx.anIntArray409 = \"" + Arrays.toString(item.recolorToReplace) + "\";");
                fw.write(System.getProperty("line.separator"));
                fw.write("gfx.modelId = \"" + item.modelId + "\";");
                fw.write(System.getProperty("line.separator"));
                fw.write("break;");
                fw.write(System.getProperty("line.separator"));
                fw.write(System.getProperty("line.separator"));
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readValues(Buffer buffer) {
        int opcode;
        while ((opcode = buffer.readUnsignedByte()) != 0) {
            int i;
            Object[] target;
            Object[] original;
            int count2;
            if (opcode == 1) {
                this.modelId = buffer.readUShort();
                continue;
            }
            if (opcode == 2) {
                this.animationId = buffer.readUShort();
                if (this.animationId == 65535) continue;
                this.animationSequence = SeqDefinition.get(this.animationId);
                continue;
            }
            if (opcode == 4) {
                this.resizeXY = buffer.readUShort();
                continue;
            }
            if (opcode == 5) {
                this.resizeZ = buffer.readUShort();
                continue;
            }
            if (opcode == 6) {
                this.rotation = buffer.readUShort();
                continue;
            }
            if (opcode == 7) {
                this.modelBrightness = buffer.readUnsignedByte();
                continue;
            }
            if (opcode == 8) {
                this.modelShadow = buffer.readUnsignedByte();
                continue;
            }
            if (opcode == 40) {
                count2 = buffer.readUnsignedByte();
                original = new int[count2];
                target = new int[count2];
                for (i = 0; i < count2; ++i) {
                    original[i] = buffer.readUnsignedShort();
                    target[i] = buffer.readUnsignedShort();
                }
                this.recolorToFind = original;
                this.recolorToReplace = target;
                continue;
            }
            if (opcode == 41) {
                count2 = buffer.readUnsignedByte();
                original = new short[count2];
                target = new short[count2];
                for (i = 0; i < count2; ++i) {
                    original[i] = (short)buffer.readUnsignedShort();
                    target[i] = (short)buffer.readUnsignedShort();
                }
                this.textureFind = (short[])original;
                this.textureReplace = (short[])target;
                continue;
            }
            System.out.println("Error unrecognised spotanim config code: " + opcode);
        }
        return;
    }

    public static GraphicsDefinition fetch(int modelId) {
        for (GraphicsDefinition anim : cache) {
            if (anim == null || anim.modelId != modelId) continue;
            return anim;
        }
        return null;
    }

    public Model getModel() {
        Model model = (Model)aMRUNodes_415.get(this.id);
        if (model != null) {
            return model;
        }
        model = Model.getModel(this.modelId);
        if (model == null) {
            return null;
        }
        for (int i = 0; i < this.recolorToFind.length; ++i) {
            if (this.recolorToFind[0] == 0) continue;
            model.recolor(this.recolorToFind[i], this.recolorToReplace[i]);
        }
        if (this.textureReplace != null) {
            for (int i1 = 0; i1 < this.textureReplace.length; ++i1) {
                model.retexture(this.textureReplace[i1], this.textureFind[i1]);
            }
        }
        aMRUNodes_415.put(model, this.id);
        return model;
    }

    private void setDefault() {
        this.modelId = -1;
        this.animationId = -1;
        this.recolorToFind = new int[6];
        this.recolorToReplace = new int[6];
        this.resizeXY = 128;
        this.resizeZ = 128;
        this.rotation = 0;
        this.modelBrightness = 0;
        this.modelShadow = 0;
    }

    public GraphicsDefinition() {
        this.anInt400 = 9;
    }

    public int getModelId() {
        return this.modelId;
    }

    public int getId() {
        return this.id;
    }

    static {
        aMRUNodes_415 = new ReferenceCache(30);
    }
}

