/*
 * Decompiled with CFR 0.152.
 */
package com.client.definitions;

import com.client.Buffer;
import com.client.Client;
import com.client.FileArchive;
import com.client.Sprite;
import java.util.HashMap;

public final class AreaDefinition {
    public static int size;
    public static AreaDefinition[] cache;
    public static HashMap<Integer, Sprite> sprites;
    private static int cacheIndex;
    private static Buffer area_data;
    private static int[] indices;
    public int id = -1;
    public int spriteId = -1;
    public int field3294 = -1;
    public String name = "";
    public int fontColor = -1;
    public int field3297 = -1;
    public String[] actions;
    public int field3310 = -1;

    private AreaDefinition() {
    }

    public static void clear() {
        indices = null;
        cache = null;
        area_data = null;
    }

    public static void init(FileArchive archive) {
        int _ctr;
        area_data = new Buffer(archive.readFile("areas.dat"));
        Buffer stream = new Buffer(archive.readFile("areas.idx"));
        size = stream.readUShort();
        indices = new int[size];
        int offset = 2;
        for (_ctr = 0; _ctr < size; ++_ctr) {
            AreaDefinition.indices[_ctr] = offset;
            offset += stream.readUShort();
        }
        cache = new AreaDefinition[10];
        for (_ctr = 0; _ctr < 10; ++_ctr) {
            AreaDefinition.cache[_ctr] = new AreaDefinition();
        }
        System.out.println("Areas read -> " + size);
    }

    public static Sprite getImage(int sprite) {
        return sprites.get(sprite);
    }

    public static AreaDefinition lookup(int area) {
        if (area < 0 || area >= indices.length) {
            System.err.println("Warning: Invalid area ID " + area);
            return AreaDefinition.getFallback();
        }
        for (int count2 = 0; count2 < 10; ++count2) {
            if (AreaDefinition.cache[count2].id != area) continue;
            return cache[count2];
        }
        cacheIndex = (cacheIndex + 1) % 10;
        AreaDefinition data2 = cache[cacheIndex];
        try {
            AreaDefinition.area_data.currentPosition = indices[area];
            data2.readValues(area_data);
            data2.id = area;
            if (!sprites.containsKey(data2.spriteId)) {
                try {
                    sprites.put(data2.spriteId, new Sprite(Client.instance.mediaStreamLoader, "mapfunction", data2.spriteId));
                }
                catch (Exception e) {
                    System.out.println("Missing Sprite: " + data2.spriteId + " Using fallback");
                    sprites.put(data2.spriteId, new Sprite(Client.instance.mediaStreamLoader, "mapfunction", 48));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return AreaDefinition.getFallback();
        }
        return data2;
    }

    private static AreaDefinition getFallback() {
        AreaDefinition def = new AreaDefinition();
        def.id = -1;
        def.name = "Unknown";
        def.spriteId = 48;
        return def;
    }

    public void readValues(Buffer buffer) {
        int opCode;
        while ((opCode = buffer.readUnsignedByte()) != 0) {
            if (opCode == 1) {
                this.spriteId = buffer.readShort();
                continue;
            }
            if (opCode == 2) {
                this.field3294 = buffer.readShort();
                continue;
            }
            if (opCode == 3) {
                this.name = buffer.readNewString();
                continue;
            }
            if (opCode == 4) {
                this.fontColor = buffer.readInt();
                continue;
            }
            if (opCode == 5) {
                this.field3297 = buffer.readInt();
                continue;
            }
            if (opCode == 6) {
                this.fontColor = buffer.readInt();
                continue;
            }
            if (opCode >= 6 && opCode < 11) {
                if (this.actions == null) {
                    this.actions = new String[5];
                }
                this.actions[opCode - 6] = buffer.readNewString();
                continue;
            }
            if (opCode != 12) continue;
            this.field3310 = buffer.readInt();
        }
        return;
    }

    static {
        sprites = new HashMap();
    }
}

