/*
 * Decompiled with CFR 0.152.
 */
package com.client.audio;

import com.client.audio.VoiceChat;
import com.client.audio.VoicePlayback;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.runelite.client.RuneLite;

public class VoiceSettings {
    private static final File SETTINGS_FILE = new File(RuneLite.CACHE_DIR, "voicesettings.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public int selectedMicrophoneIndex = 0;
    public int selectedSpeakerIndex = 0;
    public int microphoneVolumePercent = 100;
    public boolean loopbackMode = false;

    public void save() {
        try {
            if (!RuneLite.CACHE_DIR.exists()) {
                RuneLite.CACHE_DIR.mkdirs();
            }
            String json = gson.toJson(this);
            Files.write(SETTINGS_FILE.toPath(), json.getBytes(), new OpenOption[0]);
            System.out.println("[VOICE SETTINGS] Settings saved to " + SETTINGS_FILE.getAbsolutePath());
        }
        catch (IOException e) {
            System.err.println("[VOICE SETTINGS] Failed to save settings: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static VoiceSettings load() {
        if (!SETTINGS_FILE.exists()) {
            System.out.println("[VOICE SETTINGS] No settings file found at " + SETTINGS_FILE.getAbsolutePath() + ", using defaults");
            return new VoiceSettings();
        }
        try {
            String json = new String(Files.readAllBytes(SETTINGS_FILE.toPath()));
            VoiceSettings settings = gson.fromJson(json, VoiceSettings.class);
            System.out.println("[VOICE SETTINGS] Settings loaded from " + SETTINGS_FILE.getAbsolutePath());
            return settings;
        }
        catch (IOException e) {
            System.err.println("[VOICE SETTINGS] Failed to load settings: " + e.getMessage());
            e.printStackTrace();
            return new VoiceSettings();
        }
    }

    public void apply() {
        VoiceChat voiceChat = VoiceChat.getInstance();
        VoicePlayback voicePlayback = VoicePlayback.getInstance();
        if (this.selectedMicrophoneIndex >= 0) {
            voiceChat.setMicrophone(this.selectedMicrophoneIndex);
        }
        if (this.selectedSpeakerIndex >= 0) {
            voicePlayback.setSpeaker(this.selectedSpeakerIndex);
        }
        voiceChat.setMicrophoneVolumePercent(this.microphoneVolumePercent);
        if (this.loopbackMode && !voiceChat.isLoopbackMode()) {
            voiceChat.toggleLoopbackMode();
        } else if (!this.loopbackMode && voiceChat.isLoopbackMode()) {
            voiceChat.toggleLoopbackMode();
        }
        System.out.println("[VOICE SETTINGS] Settings applied: mic=" + this.selectedMicrophoneIndex + ", speaker=" + this.selectedSpeakerIndex + ", volume=" + this.microphoneVolumePercent + "%, loopback=" + this.loopbackMode);
    }

    public static VoiceSettings fromCurrent() {
        VoiceSettings settings = new VoiceSettings();
        VoiceChat voiceChat = VoiceChat.getInstance();
        VoicePlayback voicePlayback = VoicePlayback.getInstance();
        settings.selectedMicrophoneIndex = voiceChat.getSelectedMicIndex();
        settings.selectedSpeakerIndex = voicePlayback.getSelectedSpeakerIndex();
        settings.microphoneVolumePercent = voiceChat.getMicrophoneVolumePercent();
        settings.loopbackMode = voiceChat.isLoopbackMode();
        return settings;
    }
}

