/*
 * Decompiled with CFR 0.152.
 */
package com.client.audio;

import com.client.Client;
import com.client.Configuration;
import com.client.audio.OpusCodec;
import com.client.audio.VoicePlayback;
import com.client.audio.VoiceWebSocketClient;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class VoiceChat {
    private static VoiceChat instance;
    private static final float SAMPLE_RATE = 16000.0f;
    private static final int SAMPLE_SIZE_BITS = 16;
    private static final int CHANNELS = 1;
    private static final boolean SIGNED = true;
    private static final boolean BIG_ENDIAN = false;
    private static final int BUFFER_SIZE = 1024;
    private static final int PACKET_INTERVAL_MS = 100;
    private static final int MAX_PACKETS_PER_SECOND = 10;
    private long lastPacketTime = 0L;
    private int packetsThisSecond = 0;
    private long currentSecondStart = 0L;
    private TargetDataLine microphone;
    private AudioFormat audioFormat = new AudioFormat(16000.0f, 16, 1, true, false);
    private boolean isRecording;
    private Thread recordingThread;
    private int selectedMicIndex = 0;
    private Mixer.Info[] availableMixers;
    private boolean loopbackMode = false;
    private float microphoneGain = 1.0f;
    private long lastAudioDetectedTime = 0L;

    private static void debug(String message) {
        if (Configuration.NewDevMode) {
            System.out.println(message);
        }
    }

    private static void debugErr(String message) {
        if (Configuration.NewDevMode) {
            System.err.println(message);
        }
    }

    private VoiceChat() {
    }

    public static VoiceChat getInstance() {
        if (instance == null) {
            instance = new VoiceChat();
        }
        return instance;
    }

    public void startRecording() {
        if (this.isRecording) {
            VoiceChat.debug("[VOICE DEBUG] Already recording, ignoring startRecording()");
            return;
        }
        VoiceChat.debug("[VOICE DEBUG] startRecording() called");
        VoiceChat.debug("[VOICE DEBUG] Client.stream: " + (Client.stream != null ? "OK" : "NULL"));
        VoiceChat.debug("[VOICE DEBUG] Client.loggedIn: " + Client.loggedIn);
        try {
            Mixer mixer;
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.audioFormat);
            Mixer.Info[] mics = this.getAvailableMicrophones();
            if (mics.length == 0) {
                System.err.println("No microphones detected!");
                Client.instance.pushMessage("Voice chat unavailable - no microphone detected", 0, "");
                return;
            }
            if (this.selectedMicIndex >= mics.length) {
                this.selectedMicIndex = 0;
            }
            if (!(mixer = AudioSystem.getMixer(mics[this.selectedMicIndex])).isLineSupported(info)) {
                System.err.println("Selected microphone does not support required format!");
                Client.instance.pushMessage("Voice chat unavailable - microphone format not supported", 0, "");
                return;
            }
            this.microphone = (TargetDataLine)mixer.getLine(info);
            Mixer.Info mixerInfo = mics[this.selectedMicIndex];
            Line.Info lineInfo = this.microphone.getLineInfo();
            VoiceChat.debug("[MIC DEBUG] Using Microphone " + (this.selectedMicIndex + 1) + "/" + mics.length);
            VoiceChat.debug("[MIC DEBUG] Microphone device: " + mixerInfo.getName());
            VoiceChat.debug("[MIC DEBUG] Device description: " + mixerInfo.getDescription());
            VoiceChat.debug("[MIC DEBUG] Device vendor: " + mixerInfo.getVendor());
            VoiceChat.debug("[MIC DEBUG] Line info: " + lineInfo.toString());
            this.microphone.open(this.audioFormat, 1024);
            this.microphone.start();
            this.isRecording = true;
            this.lastAudioDetectedTime = System.currentTimeMillis();
            this.recordingThread = new Thread(this::captureAndTransmit);
            this.recordingThread.setName("VoiceChat-Capture");
            this.recordingThread.setDaemon(true);
            this.recordingThread.start();
            VoiceChat.debug("[VOICE CHAT] Recording started - microphone active");
            VoiceChat.debug("[VOICE CHAT] Audio format: 16000.0Hz, 16bit, 1 channel(s)");
        }
        catch (LineUnavailableException e) {
            VoiceChat.debugErr("[VOICE CHAT] Failed to open microphone: " + e.getMessage());
            e.printStackTrace();
            Client.instance.pushMessage("Voice chat unavailable - microphone in use", 0, "");
        }
        catch (Exception e) {
            VoiceChat.debugErr("[VOICE CHAT] Unexpected error starting recording: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void stopRecording() {
        if (!this.isRecording) {
            return;
        }
        this.isRecording = false;
        if (this.recordingThread != null) {
            this.recordingThread.interrupt();
            try {
                this.recordingThread.join(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.microphone != null) {
            this.microphone.stop();
            this.microphone.close();
            this.microphone = null;
        }
        VoiceChat.debug("[VOICE CHAT] Recording stopped - microphone released");
    }

    private void captureAndTransmit() {
        byte[] buffer = new byte[1024];
        int captureCount = 0;
        VoiceChat.debug("[VOICE DEBUG] Capture loop started");
        while (this.isRecording && !Thread.currentThread().isInterrupted()) {
            try {
                int bytesRead = this.microphone.read(buffer, 0, buffer.length);
                if (++captureCount % 20 == 0) {
                    VoiceChat.debug("[VOICE DEBUG] Captured " + captureCount + " audio chunks so far");
                }
                if (bytesRead <= 0) continue;
                this.applyVolumeGain(buffer, bytesRead, this.microphoneGain);
                double audioLevel = this.calculateAudioLevel(buffer, bytesRead);
                if (captureCount <= 3) {
                    StringBuilder samples = new StringBuilder("[VOICE DEBUG] First 10 samples: ");
                    for (int i = 0; i < Math.min(20, bytesRead); i += 2) {
                        short sample2 = (short)(buffer[i + 1] << 8 | buffer[i] & 0xFF);
                        samples.append(sample2).append(" ");
                    }
                    VoiceChat.debug(samples.toString());
                }
                if (!this.hasAudioSignal(buffer, bytesRead)) continue;
                this.lastAudioDetectedTime = System.currentTimeMillis();
                if (this.loopbackMode) {
                    VoicePlayback playback = VoicePlayback.getInstance();
                    if (playback == null) continue;
                    byte[] audioToPlay = new byte[bytesRead];
                    System.arraycopy(buffer, 0, audioToPlay, 0, bytesRead);
                    playback.queueAudio("LOOPBACK", audioToPlay);
                    continue;
                }
                this.sendAudioPacket(buffer, bytesRead);
            }
            catch (Exception e) {
                VoiceChat.debugErr("[VOICE DEBUG] Error capturing audio: " + e.getMessage());
                e.printStackTrace();
                break;
            }
        }
        VoiceChat.debug("[VOICE DEBUG] Capture loop ended");
    }

    private void applyVolumeGain(byte[] buffer, int length, float gain) {
        if (gain == 1.0f) {
            return;
        }
        for (int i = 0; i < length; i += 2) {
            short sample2 = (short)(buffer[i + 1] << 8 | buffer[i] & 0xFF);
            int amplified = (int)((float)sample2 * gain);
            if (amplified > Short.MAX_VALUE) {
                amplified = Short.MAX_VALUE;
            } else if (amplified < Short.MIN_VALUE) {
                amplified = Short.MIN_VALUE;
            }
            buffer[i] = (byte)(amplified & 0xFF);
            buffer[i + 1] = (byte)(amplified >> 8 & 0xFF);
        }
    }

    private double calculateAudioLevel(byte[] buffer, int length) {
        long sum = 0L;
        for (int i = 0; i < length; i += 2) {
            short sample2 = (short)(buffer[i + 1] << 8 | buffer[i] & 0xFF);
            sum += (long)(sample2 * sample2);
        }
        return Math.sqrt((double)sum / ((double)length / 2.0));
    }

    private boolean hasAudioSignal(byte[] buffer, int length) {
        double threshold;
        long sum = 0L;
        for (int i = 0; i < length; i += 2) {
            short sample2 = (short)(buffer[i + 1] << 8 | buffer[i] & 0xFF);
            sum += (long)(sample2 * sample2);
        }
        double rms = Math.sqrt((double)sum / ((double)length / 2.0));
        return rms > (threshold = 10.0);
    }

    private void sendAudioPacket(byte[] audioData, int length) {
        try {
            byte[] compressedAudio;
            long currentTime;
            block12: {
                if (!Client.loggedIn) {
                    VoiceChat.debugErr("[VOICE DEBUG] Cannot send - not logged in");
                    return;
                }
                currentTime = System.currentTimeMillis();
                if (currentTime - this.currentSecondStart >= 1000L) {
                    this.currentSecondStart = currentTime;
                    this.packetsThisSecond = 0;
                }
                if (this.packetsThisSecond >= 10) {
                    if (this.packetsThisSecond == 10) {
                        VoiceChat.debug("[VOICE DEBUG] Rate limit reached - throttling packets");
                    }
                    return;
                }
                if (currentTime - this.lastPacketTime < 100L) {
                    return;
                }
                byte[] audioToSend = audioData;
                if (length != audioData.length) {
                    audioToSend = new byte[length];
                    System.arraycopy(audioData, 0, audioToSend, 0, length);
                }
                compressedAudio = audioToSend;
                try {
                    OpusCodec codec = OpusCodec.getInstance();
                    compressedAudio = codec.encode(audioToSend);
                    VoiceChat.debug("[OPUS] Compressed " + audioToSend.length + " bytes \u2192 " + compressedAudio.length + " bytes (" + String.format("%.1f", (1.0 - (double)compressedAudio.length / (double)audioToSend.length) * 100.0) + "% reduction)");
                }
                catch (Exception | NoClassDefFoundError e) {
                    if (this.packetsThisSecond != 0) break block12;
                    VoiceChat.debug("[VOICE DEBUG] Opus not available, sending uncompressed PCM (" + audioToSend.length + " bytes)");
                }
            }
            VoiceWebSocketClient wsClient = VoiceWebSocketClient.getInstance();
            if (wsClient != null && wsClient.isConnectedAndAuthenticated()) {
                VoiceChat.debug("[VOICE DEBUG] Sending via WebSocket - " + compressedAudio.length + " bytes (compressed)");
                wsClient.sendAudio(compressedAudio);
                this.lastPacketTime = currentTime;
                ++this.packetsThisSecond;
                VoiceChat.debug("[VOICE DEBUG] Sent audio via WebSocket (packet " + this.packetsThisSecond + "/10 this second)");
            } else {
                VoiceChat.debugErr("[VOICE DEBUG] Cannot send - WebSocket not connected");
            }
        }
        catch (Exception e) {
            VoiceChat.debugErr("[VOICE DEBUG] Error sending audio packet: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public Mixer.Info[] getAvailableMicrophones() {
        if (this.availableMixers == null) {
            Mixer.Info[] allMixers;
            AudioFormat format = new AudioFormat(16000.0f, 16, 1, true, false);
            DataLine.Info targetInfo = new DataLine.Info(TargetDataLine.class, format);
            ArrayList<Mixer.Info> micList = new ArrayList<Mixer.Info>();
            for (Mixer.Info mixerInfo : allMixers = AudioSystem.getMixerInfo()) {
                Mixer mixer = AudioSystem.getMixer(mixerInfo);
                if (!mixer.isLineSupported(targetInfo)) continue;
                micList.add(mixerInfo);
            }
            this.availableMixers = micList.toArray(new Mixer.Info[0]);
        }
        return this.availableMixers;
    }

    public String switchMicrophone() {
        Mixer.Info[] mics = this.getAvailableMicrophones();
        if (mics.length == 0) {
            return "No microphones detected!";
        }
        boolean wasRecording = this.isRecording;
        if (wasRecording) {
            this.stopRecording();
        }
        this.selectedMicIndex = (this.selectedMicIndex + 1) % mics.length;
        String result2 = "Microphone " + (this.selectedMicIndex + 1) + "/" + mics.length + ": " + mics[this.selectedMicIndex].getName();
        if (wasRecording) {
            this.startRecording();
        }
        return result2;
    }

    public String getCurrentMicrophoneInfo() {
        Mixer.Info[] mics = this.getAvailableMicrophones();
        if (mics.length == 0) {
            return "No microphones detected!";
        }
        return "Active: Microphone " + (this.selectedMicIndex + 1) + "/" + mics.length + ": " + mics[this.selectedMicIndex].getName();
    }

    public boolean testMicrophonePermissions() {
        VoiceChat.debug("[MIC PERMS] Testing microphone permissions...");
        try {
            Mixer.Info[] mics = this.getAvailableMicrophones();
            if (mics.length == 0) {
                VoiceChat.debug("[MIC PERMS] No microphones detected by system");
                return false;
            }
            VoiceChat.debug("[MIC PERMS] Found " + mics.length + " microphone(s)");
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.audioFormat);
            Mixer mixer = AudioSystem.getMixer(mics[this.selectedMicIndex]);
            TargetDataLine testLine = (TargetDataLine)mixer.getLine(info);
            testLine.open(this.audioFormat, 512);
            testLine.start();
            byte[] testBuffer = new byte[512];
            int bytesRead = testLine.read(testBuffer, 0, testBuffer.length);
            testLine.stop();
            testLine.close();
            if (bytesRead > 0) {
                boolean hasData = false;
                for (byte b : testBuffer) {
                    if (b == 0) continue;
                    hasData = true;
                    break;
                }
                if (hasData) {
                    VoiceChat.debug("[MIC PERMS] \u2713 Microphone access GRANTED - audio data received");
                    return true;
                }
                VoiceChat.debug("[MIC PERMS] \u26a0 Microphone opened but receiving silence (may need permission)");
                return false;
            }
            VoiceChat.debug("[MIC PERMS] \u2717 Microphone opened but no data received");
            return false;
        }
        catch (SecurityException e) {
            VoiceChat.debug("[MIC PERMS] \u2717 PERMISSION DENIED - Security exception: " + e.getMessage());
            return false;
        }
        catch (LineUnavailableException e) {
            VoiceChat.debug("[MIC PERMS] \u2717 Microphone unavailable: " + e.getMessage());
            return false;
        }
        catch (Exception e) {
            VoiceChat.debug("[MIC PERMS] \u2717 Error testing microphone: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void openMicrophoneSettings() {
        try {
            String os = System.getProperty("os.name").toLowerCase();
            VoiceChat.debug("[MIC PERMS] Detected OS: " + os);
            if (os.contains("mac")) {
                Runtime.getRuntime().exec(new String[]{"open", "x-apple.systempreferences:com.apple.preference.security?Privacy_Microphone"});
                VoiceChat.debug("[MIC PERMS] Opening macOS microphone settings...");
            } else if (os.contains("win")) {
                Runtime.getRuntime().exec("ms-settings:privacy-microphone");
                VoiceChat.debug("[MIC PERMS] Opening Windows microphone settings...");
            } else {
                VoiceChat.debug("[MIC PERMS] Automatic settings not supported for this OS");
            }
        }
        catch (Exception e) {
            VoiceChat.debug("[MIC PERMS] Could not open system settings: " + e.getMessage());
        }
    }

    public boolean toggleLoopbackMode() {
        this.loopbackMode = !this.loopbackMode;
        VoiceChat.debug("[LOOPBACK] Loopback mode " + (this.loopbackMode ? "ENABLED" : "DISABLED"));
        VoiceChat.debug("[LOOPBACK] " + (this.loopbackMode ? "You will hear your own voice" : "Audio will be sent to server"));
        return this.loopbackMode;
    }

    public boolean isLoopbackMode() {
        return this.loopbackMode;
    }

    public int getSelectedMicIndex() {
        return this.selectedMicIndex;
    }

    public String setMicrophone(int index) {
        Mixer.Info[] mics = this.getAvailableMicrophones();
        if (mics.length == 0) {
            return "No microphones detected!";
        }
        if (index < 0 || index >= mics.length) {
            return "Invalid microphone index!";
        }
        boolean wasRecording = this.isRecording;
        if (wasRecording) {
            this.stopRecording();
        }
        this.selectedMicIndex = index;
        String result2 = "Microphone " + (this.selectedMicIndex + 1) + "/" + mics.length + ": " + mics[this.selectedMicIndex].getName();
        if (wasRecording) {
            this.startRecording();
        }
        return result2;
    }

    public float getMicrophoneGain() {
        return this.microphoneGain;
    }

    public void setMicrophoneGain(float gain) {
        if (gain < 0.0f) {
            gain = 0.0f;
        } else if (gain > 2.0f) {
            gain = 2.0f;
        }
        this.microphoneGain = gain;
        VoiceChat.debug("[MIC GAIN] Microphone volume set to " + (int)(gain * 100.0f) + "%");
    }

    public int getMicrophoneVolumePercent() {
        return (int)(this.microphoneGain * 100.0f);
    }

    public void setMicrophoneVolumePercent(int percent) {
        float gain = (float)percent / 100.0f;
        this.setMicrophoneGain(gain);
    }

    public long getTimeSinceLastAudio() {
        if (this.lastAudioDetectedTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.lastAudioDetectedTime;
    }

    public void resetLastAudioTime() {
        this.lastAudioDetectedTime = System.currentTimeMillis();
    }
}

