/*
 * Decompiled with CFR 0.152.
 */
package com.client.audio;

import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import tomp2p.opuswrapper.Opus;

public class OpusCodec {
    private static final int SAMPLE_RATE = 16000;
    private static final int CHANNELS = 1;
    private static final int FRAME_SIZE = 320;
    private static final int MAX_PACKET_SIZE = 4000;
    private static final int APPLICATION = 2048;
    private PointerByReference encoder;
    private PointerByReference decoder;
    private static OpusCodec instance;

    private OpusCodec() throws Exception {
        IntBuffer error = IntBuffer.allocate(1);
        this.encoder = Opus.INSTANCE.opus_encoder_create(16000, 1, 2048, error);
        if (error.get(0) != 0) {
            throw new Exception("Failed to create Opus encoder: error code " + error.get(0));
        }
        Opus.INSTANCE.opus_encoder_ctl(this.encoder, 4002, 24000);
        Opus.INSTANCE.opus_encoder_ctl(this.encoder, 4010, 5);
        Opus.INSTANCE.opus_encoder_ctl(this.encoder, 4024, 3001);
        Opus.INSTANCE.opus_encoder_ctl(this.encoder, 4006, 1);
        Opus.INSTANCE.opus_encoder_ctl(this.encoder, 4020, 1);
        error.clear();
        this.decoder = Opus.INSTANCE.opus_decoder_create(16000, 1, error);
        if (error.get(0) != 0) {
            throw new Exception("Failed to create Opus decoder: error code " + error.get(0));
        }
        System.out.println("[OPUS] Codec initialized - 16kHz, mono, 24kbps, VOIP mode");
    }

    public static OpusCodec getInstance() throws Exception {
        if (instance == null) {
            instance = new OpusCodec();
        }
        return instance;
    }

    public byte[] encode(byte[] pcmData) throws Exception {
        ByteBuffer opusBuffer;
        if (pcmData == null || pcmData.length == 0) {
            throw new IllegalArgumentException("PCM data cannot be null or empty");
        }
        int sampleCount = pcmData.length / 2;
        short[] pcmSamples = new short[sampleCount];
        for (int i = 0; i < sampleCount; ++i) {
            pcmSamples[i] = (short)(pcmData[i * 2] & 0xFF | pcmData[i * 2 + 1] << 8);
        }
        ShortBuffer pcmBuffer = ShortBuffer.wrap(pcmSamples);
        int encodedBytes = Opus.INSTANCE.opus_encode(this.encoder, pcmBuffer, 320, opusBuffer = ByteBuffer.allocate(4000), 4000);
        if (encodedBytes < 0) {
            throw new Exception("Opus encoding failed with error code: " + encodedBytes);
        }
        byte[] result2 = new byte[encodedBytes];
        opusBuffer.get(result2, 0, encodedBytes);
        return result2;
    }

    public byte[] decode(byte[] opusPacket) throws Exception {
        if (opusPacket == null || opusPacket.length == 0) {
            throw new IllegalArgumentException("Opus packet cannot be null or empty");
        }
        ShortBuffer pcmBuffer = ShortBuffer.allocate(1920);
        int decodedSamples = Opus.INSTANCE.opus_decode(this.decoder, opusPacket, opusPacket.length, pcmBuffer, 1920, 0);
        if (decodedSamples < 0) {
            throw new Exception("Opus decoding failed with error code: " + decodedSamples);
        }
        byte[] pcmData = new byte[decodedSamples * 2];
        for (int i = 0; i < decodedSamples; ++i) {
            short sample2 = pcmBuffer.get(i);
            pcmData[i * 2] = (byte)(sample2 & 0xFF);
            pcmData[i * 2 + 1] = (byte)(sample2 >> 8 & 0xFF);
        }
        return pcmData;
    }

    public String getFormatInfo() {
        return String.format("Opus - %dkHz, %d channel(s), %d samples/frame", 16, 1, 320);
    }

    public void destroy() {
        if (this.encoder != null) {
            Opus.INSTANCE.opus_encoder_destroy(this.encoder);
            this.encoder = null;
        }
        if (this.decoder != null) {
            Opus.INSTANCE.opus_decoder_destroy(this.decoder);
            this.decoder = null;
        }
        System.out.println("[OPUS] Codec destroyed");
    }
}

