/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Buffer;
import com.client.FileArchive;

public final class Varp {
    public static int cacheSize;
    public int anInt709;
    public static Varp[] cache;
    private static int anInt702;
    private static int[] activeVarpIDs;
    public static int[] varpValues;
    public int configID;
    public boolean isEnabled = false;
    public String description;

    public static void unpackConfig(FileArchive streamLoader) {
        Buffer stream = new Buffer(streamLoader.getArchiveData("varp.dat"));
        anInt702 = 0;
        cacheSize = stream.readUShort();
        if (cache == null) {
            cache = new Varp[cacheSize + 1000];
        }
        if (activeVarpIDs == null) {
            activeVarpIDs = new int[cacheSize];
        }
        for (int j = 0; j < cacheSize; ++j) {
            if (cache[j] == null) {
                Varp.cache[j] = new Varp();
            }
            cache[j].readValues(stream, j);
        }
        if (stream.currentPosition != stream.payload.length) {
            System.out.println("Error: varptype load mismatch.");
        }
    }

    private void readValues(Buffer stream, int i) {
        int opcode;
        block10: while ((opcode = stream.readUnsignedByte()) != 0) {
            switch (opcode) {
                case 1: {
                    stream.readUnsignedByte();
                    continue block10;
                }
                case 2: {
                    stream.readUnsignedByte();
                    continue block10;
                }
                case 3: {
                    Varp.activeVarpIDs[Varp.anInt702++] = i;
                    continue block10;
                }
                case 5: {
                    this.configID = stream.readUShort();
                    continue block10;
                }
                case 7: {
                    stream.readDWord();
                    continue block10;
                }
                case 8: 
                case 11: {
                    this.isEnabled = true;
                    continue block10;
                }
                case 10: {
                    this.description = stream.readString();
                    continue block10;
                }
                case 12: {
                    stream.readDWord();
                    continue block10;
                }
            }
            System.out.println("Warning: Unrecognized config opcode: " + opcode);
        }
        return;
    }

    public static Varp get(int id) {
        if (id < 0 || id >= cache.length || cache[id] == null) {
            return null;
        }
        return cache[id];
    }

    public static void setVarp(int id, int value) {
        if (id >= 0 && id < cache.length && cache[id] != null) {
            Varp.varpValues[id] = value;
        } else {
            System.out.println("Error: Invalid Varp ID " + id);
        }
    }

    public static int getVarpValue(int id) {
        if (id >= 0 && id < cache.length && cache[id] != null) {
            return varpValues[id];
        }
        return -1;
    }

    public static void resetVarps() {
        for (int i = 0; i < varpValues.length; ++i) {
            Varp.varpValues[i] = 0;
        }
        System.out.println("All Varps have been reset.");
    }

    public static void debugActiveVarps() {
        System.out.println("Active Varps:");
        for (int id : activeVarpIDs) {
            if (id == 0) continue;
            System.out.printf("ID: %d, Value: %d%n", id, Varp.getVarpValue(id));
        }
    }

    private Varp() {
    }

    static {
        varpValues = new int[5000];
    }
}

