/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Buffer;
import com.client.Client;
import com.client.Entity;
import com.client.EntitySpotAnim;
import com.client.IDK;
import com.client.Model;
import com.client.PlayerRights;
import com.client.ReferenceCache;
import com.client.definitions.GraphicsDefinition;
import com.client.definitions.ItemDefinition;
import com.client.definitions.NpcDefinition;
import com.client.definitions.SeqDefinition;
import com.client.definitions.SeqFrame;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.runelite.api.Actor;
import net.runelite.api.ActorSpotAnim;
import net.runelite.api.HeadIcon;
import net.runelite.api.IterableHashTable;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.SkullIcon;
import net.runelite.api.SpritePixels;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.rs.api.RSIterableNodeDeque;
import net.runelite.rs.api.RSModel;
import net.runelite.rs.api.RSNPC;
import net.runelite.rs.api.RSNode;
import net.runelite.rs.api.RSPlayer;
import net.runelite.rs.api.RSPlayerComposition;
import net.runelite.rs.api.RSUsername;
import org.jetbrains.annotations.Nullable;

public final class Player
extends Entity
implements RSPlayer {
    public int usedItemID;
    public String title;
    public String titleColor;
    public int faceX = -1;
    public int faceY = -1;
    public boolean faceCoordinateUpdate = false;
    public int privelage;
    private PlayerRights[] rights = new PlayerRights[]{PlayerRights.PLAYER};
    public int centurion;
    private List<PlayerRights> displayedRights = new ArrayList<PlayerRights>();
    private long aLong1697 = -1L;
    public NpcDefinition npcDefinition;
    boolean aBoolean1699 = false;
    final int[] anIntArray1700;
    public int team;
    public int myGender;
    public String displayName;
    public int playerId;
    static ReferenceCache mruNodes = new ReferenceCache(260);
    public int combatLevel;
    public int headIcon;
    public int skullIcon;
    public int hintIcon;
    public boolean isSpeaking = false;
    public int anInt1707;
    int anInt1708;
    int anInt1709;
    boolean visible = false;
    int anInt1711;
    int anInt1712;
    int anInt1713;
    Model aModel_1714;
    public final int[] equipment;
    public int[][] colourFind = new int[12][];
    public int[][] colourReplace = new int[12][];
    private long aLong1718;
    int anInt1719;
    int anInt1720;
    int anInt1721;
    int anInt1722;
    int skill;
    private int healthState;
    public boolean hideDonor = false;
    public boolean deadPlayer = false;

    @Override
    public Model getRotatedModel() {
        if (!this.visible) {
            return null;
        }
        Model model = this.method452();
        if (model == null) {
            return null;
        }
        this.height = model.modelBaseY;
        model.singleTile = true;
        if (this.aBoolean1699) {
            return model;
        }
        for (EntitySpotAnim graphicObject : this.spotAnims) {
            if (graphicObject.getId() == -1) {
                graphicObject.remove();
                continue;
            }
            GraphicsDefinition spotAnim = GraphicsDefinition.cache[graphicObject.getId()];
            Model model_2 = spotAnim.getModel();
            if (model_2 == null) continue;
            SeqDefinition seq = spotAnim.animationSequence;
            Model model_3 = new Model(true, SeqFrame.noAnimationInProgress(graphicObject.getFrame()), false, model_2);
            model_3.offsetBy(0, -graphicObject.getHeight(), 0);
            if (seq != null && seq.isSkeletalAnimation()) {
                model_3.playSkeletal(seq, graphicObject.getFrame());
            } else {
                model_3.generateBones();
                model_3.interpolate(spotAnim.animationSequence.frameIDs[graphicObject.getFrame()]);
            }
            model_3.groupedTriangleLabels = null;
            model_3.groupedVertexLabels = null;
            if (spotAnim.resizeXY != 128 || spotAnim.resizeZ != 128) {
                model_3.scale(spotAnim.resizeXY, spotAnim.resizeXY, spotAnim.resizeZ);
            }
            model_3.light(64 + spotAnim.modelBrightness, 850 + spotAnim.modelShadow, -30, -50, -30, true);
            Model[] aclass30_sub2_sub4_sub6_1s = new Model[]{model, model_3};
            model = new Model(aclass30_sub2_sub4_sub6_1s);
        }
        if (this.aModel_1714 != null) {
            if (Client.loopCycle >= this.anInt1708) {
                this.aModel_1714 = null;
            }
            if (Client.loopCycle >= this.anInt1707 && Client.loopCycle < this.anInt1708) {
                Model model_1 = this.aModel_1714;
                model_1.offsetBy(this.anInt1711 - this.x, this.anInt1712 - this.anInt1709, this.anInt1713 - this.y);
                if (super.getTurnDirection() == 512) {
                    model_1.rotate90Degrees();
                    model_1.rotate90Degrees();
                    model_1.rotate90Degrees();
                } else if (super.getTurnDirection() == 1024) {
                    model_1.rotate90Degrees();
                    model_1.rotate90Degrees();
                } else if (super.getTurnDirection() == 1536) {
                    model_1.rotate90Degrees();
                }
                Model[] aclass30_sub2_sub4_sub6s = new Model[]{model, model_1};
                model = new Model(aclass30_sub2_sub4_sub6s);
                if (super.getTurnDirection() == 512) {
                    model_1.rotate90Degrees();
                } else if (super.getTurnDirection() == 1024) {
                    model_1.rotate90Degrees();
                    model_1.rotate90Degrees();
                } else if (super.getTurnDirection() == 1536) {
                    model_1.rotate90Degrees();
                    model_1.rotate90Degrees();
                    model_1.rotate90Degrees();
                }
                model_1.offsetBy(this.x - this.anInt1711, this.anInt1709 - this.anInt1712, this.y - this.anInt1713);
            }
        }
        model.singleTile = true;
        return model;
    }

    public void updatePlayer(Buffer stream) {
        stream.currentPosition = 0;
        this.colourFind = new int[12][];
        this.colourReplace = new int[12][];
        this.myGender = stream.readUnsignedByte();
        this.title = stream.readString();
        this.titleColor = stream.readString();
        this.healthState = stream.readUnsignedByte();
        this.headIcon = stream.readUnsignedByte();
        this.skullIcon = stream.readUnsignedByte();
        int speakingByte = stream.readUnsignedByte();
        this.isSpeaking = speakingByte == 1;
        System.out.println("[VOICE DEBUG CLIENT] updatePlayer for " + this.displayName);
        System.out.println("[VOICE DEBUG CLIENT] Read isSpeaking byte: " + speakingByte + " -> isSpeaking=" + this.isSpeaking);
        this.npcDefinition = null;
        this.team = 0;
        for (int j = 0; j < 12; ++j) {
            int l1;
            int k = stream.readUnsignedByte();
            if (k == 0) {
                this.equipment[j] = 0;
                continue;
            }
            int i1 = stream.readUnsignedByte();
            this.equipment[j] = (k << 8) + i1;
            if (j == 0 && this.equipment[0] == 65535) {
                this.npcDefinition = NpcDefinition.lookup(stream.readUShort());
                break;
            }
            if (j == 8) {
                Client.myHeadAndJaw[0] = this.equipment[j] - 256;
            }
            if (j == 11) {
                Client.myHeadAndJaw[1] = this.equipment[j] - 256;
            }
            if (this.equipment[j] < 512 || this.equipment[j] - 512 >= ItemDefinition.totalItems || (l1 = ItemDefinition.lookup((int)(this.equipment[j] - 512)).team) == 0) continue;
            this.team = l1;
        }
        for (int l = 0; l < 5; ++l) {
            int j1 = stream.readUnsignedByte();
            if (j1 < 0 || j1 >= Client.anIntArrayArray1003[l].length) {
                j1 = 0;
            }
            this.anIntArray1700[l] = j1;
        }
        this.seqStandID = stream.readUShort();
        if (this.seqStandID == 65535) {
            this.seqStandID = -1;
        }
        this.standTurnAnimIndex = stream.readUShort();
        if (this.standTurnAnimIndex == 65535) {
            this.standTurnAnimIndex = -1;
        }
        this.walkAnimIndex = stream.readUShort();
        if (this.walkAnimIndex == 65535) {
            this.walkAnimIndex = -1;
        }
        this.turn180AnimIndex = stream.readUShort();
        if (this.turn180AnimIndex == 65535) {
            this.turn180AnimIndex = -1;
        }
        this.turn90CWAnimIndex = stream.readUShort();
        if (this.turn90CWAnimIndex == 65535) {
            this.turn90CWAnimIndex = -1;
        }
        this.turn90CCWAnimIndex = stream.readUShort();
        if (this.turn90CCWAnimIndex == 65535) {
            this.turn90CCWAnimIndex = -1;
        }
        this.anInt1505 = stream.readUShort();
        if (this.anInt1505 == 65535) {
            this.anInt1505 = -1;
        }
        this.displayName = stream.readString();
        this.playerId = stream.readInt();
        this.hideDonor = Boolean.parseBoolean(stream.readString());
        this.visible = stream.readUnsignedByte() == 0;
        this.centurion = stream.readUnsignedByte();
        this.combatLevel = stream.readUnsignedByte();
        this.rights = PlayerRights.readRightsFromPacket(stream).getRight();
        this.displayedRights = PlayerRights.getDisplayedRights(this.rights);
        this.skill = stream.readUShort();
        this.aLong1718 = 0L;
        for (int k1 = 0; k1 < 12; ++k1) {
            this.aLong1718 <<= 4;
            if (this.equipment[k1] >= 256) {
                this.aLong1718 += (long)(this.equipment[k1] - 256);
            }
            if (this.colourFind[k1] == null) continue;
            for (int i = 0; i < this.colourFind[k1].length; ++i) {
                this.aLong1718 += (long)this.colourReplace[k1][i];
            }
        }
        if (this.equipment[0] >= 256) {
            this.aLong1718 += (long)(this.equipment[0] - 256 >> 4);
        }
        if (this.equipment[1] >= 256) {
            this.aLong1718 += (long)(this.equipment[1] - 256 >> 8);
        }
        for (int i2 = 0; i2 < 5; ++i2) {
            this.aLong1718 <<= 3;
            this.aLong1718 += (long)this.anIntArray1700[i2];
        }
        this.aLong1718 <<= 1;
        this.aLong1718 += (long)this.myGender;
    }

    public Model method452() {
        SeqDefinition primarySeq = null;
        int current_frame = -1;
        if (this.npcDefinition != null) {
            if (this.primarySeqID >= 0 && this.primarySeqDelay == 0 && !(primarySeq = SeqDefinition.get(this.primarySeqID)).isSkeletalAnimation()) {
                current_frame = primarySeq.getFrameIDs()[this.primarySeqFrame];
            }
            if (primarySeq != null && primarySeq.isSkeletalAnimation()) {
                return this.npcDefinition.getAnimatedModelSkeletal(primarySeq, null, this.primarySeqFrame, this.secondarySeqFrame);
            }
            return this.npcDefinition.getAnimatedModel(-1, current_frame, null);
        }
        long l = this.aLong1718;
        int k = -1;
        int i1 = -1;
        int j1 = -1;
        int k1 = -1;
        if (this.primarySeqID >= 0 && this.primarySeqDelay == 0) {
            SeqDefinition animation = SeqDefinition.get(this.primarySeqID);
            k = animation.frameIDs[this.primarySeqFrame];
            if (this.secondarySeqID >= 0 && this.secondarySeqID != this.seqStandID) {
                i1 = SeqDefinition.get((int)this.secondarySeqID).frameIDs[this.secondarySeqFrame];
            }
            if (animation.leftHandItem >= 0) {
                j1 = animation.leftHandItem;
                l += (long)(j1 - this.equipment[5] << 40);
            }
            if (animation.rightHandItem >= 0) {
                k1 = animation.rightHandItem;
                l += (long)(k1 - this.equipment[3] << 48);
            }
        } else if (this.secondarySeqID >= 0) {
            k = SeqDefinition.get((int)this.secondarySeqID).frameIDs[this.secondarySeqFrame];
        }
        Model model_1 = (Model)mruNodes.get(l);
        if (model_1 == null) {
            boolean flag = false;
            for (int i2 = 0; i2 < 12; ++i2) {
                int k2 = this.equipment[i2];
                if (k1 >= 0 && i2 == 3) {
                    k2 = k1;
                }
                if (j1 >= 0 && i2 == 5) {
                    k2 = j1;
                }
                if (k2 >= 256 && k2 < 512 && !IDK.cache[k2 - 256].method537()) {
                    flag = true;
                }
                if (k2 < 512 || ItemDefinition.lookup(k2 - 512).isEquippedModelCached(this.myGender)) continue;
                flag = true;
            }
            if (flag) {
                if (this.aLong1697 != -1L) {
                    model_1 = (Model)mruNodes.get(this.aLong1697);
                }
                if (model_1 == null) {
                    return null;
                }
            }
        }
        if (model_1 == null) {
            Model[] aclass30_sub2_sub4_sub6s = new Model[12];
            int j2 = 0;
            for (int l2 = 0; l2 < 12; ++l2) {
                Model model_4;
                Model model_3;
                int i3 = this.equipment[l2];
                if (k1 >= 0 && l2 == 3) {
                    i3 = k1;
                }
                if (j1 >= 0 && l2 == 5) {
                    i3 = j1;
                }
                if (i3 >= 256 && i3 < 512 && (model_3 = IDK.cache[i3 - 256].method538()) != null) {
                    aclass30_sub2_sub4_sub6s[j2++] = model_3;
                }
                if (i3 < 512 || (model_4 = ItemDefinition.lookup(i3 - 512).getEquippedModel(this.myGender)) == null) continue;
                aclass30_sub2_sub4_sub6s[j2++] = model_4;
            }
            model_1 = new Model(j2, aclass30_sub2_sub4_sub6s);
            for (int j3 = 0; j3 < 5; ++j3) {
                if (this.anIntArray1700[j3] == 0) continue;
                model_1.recolor(Client.anIntArrayArray1003[j3][0], Client.anIntArrayArray1003[j3][this.anIntArray1700[j3]]);
                if (j3 != 1) continue;
                model_1.recolor(Client.anIntArray1204[0], Client.anIntArray1204[this.anIntArray1700[j3]]);
            }
            model_1.generateBones();
            model_1.light(64, 850, -30, -50, -30, true);
            mruNodes.put(model_1, l);
            this.aLong1697 = l;
        }
        if (this.aBoolean1699) {
            return model_1;
        }
        Model model_2 = Model.emptyModel;
        model_2.buildSharedSequenceModel(model_1, SeqFrame.noAnimationInProgress(k) & SeqFrame.noAnimationInProgress(i1));
        if (k != -1 && i1 != -1) {
            model_2.mix(SeqDefinition.get((int)this.primarySeqID).masks, i1, k);
        } else if (k != -1) {
            model_2.interpolate(k);
        }
        model_2.calculateBoundsCylinder();
        model_2.groupedTriangleLabels = null;
        model_2.groupedVertexLabels = null;
        return model_2;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public boolean isAdminRights() {
        return this.hasRights(PlayerRights.ADMINISTRATOR) || this.hasRights(PlayerRights.STAFF_MANAGER) || this.hasRights(PlayerRights.OWNER);
    }

    public boolean hasRightsOtherThan(PlayerRights playerRight) {
        return PlayerRights.hasRightsOtherThan(this.rights, playerRight);
    }

    public boolean hasRights(PlayerRights playerRights) {
        return PlayerRights.hasRights(this.rights, playerRights);
    }

    public boolean hasRightsLevel(int rightsId) {
        return PlayerRights.hasRightsLevel(this.rights, rightsId);
    }

    public boolean hasRightsBetween(int low, int high) {
        return PlayerRights.hasRightsBetween(this.rights, low, high);
    }

    public Model method453() {
        if (!this.visible) {
            return null;
        }
        if (this.npcDefinition != null) {
            return this.npcDefinition.method160();
        }
        boolean flag = false;
        for (int i = 0; i < 12; ++i) {
            int j = this.equipment[i];
            if (j >= 256 && j < 512 && !IDK.cache[j - 256].method539()) {
                flag = true;
            }
            if (j < 512 || ItemDefinition.lookup(j - 512).isDialogueModelCached(this.myGender)) continue;
            flag = true;
        }
        if (flag) {
            return null;
        }
        Model[] aclass30_sub2_sub4_sub6s = new Model[12];
        int k = 0;
        for (int l = 0; l < 12; ++l) {
            Model model_2;
            Model model_1;
            int i1 = this.equipment[l];
            if (i1 >= 256 && i1 < 512 && (model_1 = IDK.cache[i1 - 256].method540()) != null) {
                aclass30_sub2_sub4_sub6s[k++] = model_1;
            }
            if (i1 < 512 || (model_2 = ItemDefinition.lookup(i1 - 512).getChatEquipModel(this.myGender)) == null) continue;
            aclass30_sub2_sub4_sub6s[k++] = model_2;
        }
        Model model = new Model(k, aclass30_sub2_sub4_sub6s);
        for (int j1 = 0; j1 < 5; ++j1) {
            if (this.anIntArray1700[j1] == 0) continue;
            model.recolor(Client.anIntArrayArray1003[j1][0], Client.anIntArrayArray1003[j1][this.anIntArray1700[j1]]);
            if (j1 != 1) continue;
            model.recolor(Client.anIntArray1204[0], Client.anIntArray1204[this.anIntArray1700[j1]]);
        }
        return model;
    }

    Player() {
        this.anIntArray1700 = new int[5];
        this.equipment = new int[12];
    }

    public boolean inFlowerPokerArea() {
        int x = this.getAbsoluteX();
        int y = this.getAbsoluteY();
        return x >= 3109 && y >= 3504 && x <= 3121 && y <= 3515;
    }

    public boolean inFlowerPokerChatProximity() {
        int x = this.getAbsoluteX();
        int y = this.getAbsoluteY();
        return x >= 3106 && y >= 3502 && x <= 3123 && y <= 3517;
    }

    public PlayerRights[] getRights() {
        return this.rights;
    }

    public List<PlayerRights> getDisplayedRights() {
        return this.displayedRights;
    }

    public int getHealthState() {
        return this.healthState;
    }

    @Override
    public String getName() {
        return this.displayName;
    }

    @Override
    public Actor getInteracting() {
        int index = this.interactingEntity;
        if (index == -1 || index == 65535) {
            return null;
        }
        Client client = Client.instance;
        if (index < 32768) {
            RSNPC[] npcs = client.getCachedNPCs();
            return npcs[index];
        }
        Player[] players = client.players;
        return players[index -= 32768];
    }

    @Override
    public int getHealthRatio() {
        return Math.round(this.currentHealth / this.maxHealth);
    }

    @Override
    public int getHealthScale() {
        return this.currentHealth;
    }

    @Override
    public WorldPoint getWorldLocation() {
        return WorldPoint.fromLocal(Client.instance, this.getPathX()[0] * 128 + 64, this.getPathY()[0] * 128 + 64, Client.instance.getPlane());
    }

    @Override
    public LocalPoint getLocalLocation() {
        return new LocalPoint(this.x, this.y);
    }

    @Override
    public void setIdleRotateLeft(int animationID) {
    }

    @Override
    public void setIdleRotateRight(int animationID) {
    }

    @Override
    public void setWalkAnimation(int animationID) {
    }

    @Override
    public void setWalkRotateLeft(int animationID) {
    }

    @Override
    public void setWalkRotateRight(int animationID) {
    }

    @Override
    public void setWalkRotate180(int animationID) {
    }

    @Override
    public void setRunAnimation(int animationID) {
    }

    @Override
    public Polygon getCanvasTilePoly() {
        return Perspective.getCanvasTilePoly(Client.instance, this.getLocalLocation());
    }

    @Override
    @Nullable
    public Point getCanvasTextLocation(Graphics2D graphics, String text, int zOffset) {
        return Perspective.getCanvasTextLocation(Client.instance, (Graphics2D)Client.instance.getGameComponent().getGraphics(), this.getLocalLocation(), text, zOffset);
    }

    @Override
    public Point getCanvasImageLocation(BufferedImage image, int zOffset) {
        return Perspective.getCanvasImageLocation(Client.instance, this.getLocalLocation(), image, zOffset);
    }

    @Override
    public Point getCanvasSpriteLocation(SpritePixels sprite, int zOffset) {
        return null;
    }

    @Override
    public Point getMinimapLocation() {
        return Perspective.localToMinimap(Client.instance, this.getLocalLocation());
    }

    @Override
    public Shape getConvexHull() {
        RSModel model = this.getModel();
        if (model == null) {
            return null;
        }
        int tileHeight = Perspective.getTileHeight(Client.instance, new LocalPoint(this.getX(), this.getY()), Client.instance.getPlane());
        return model.getConvexHull(this.getX(), this.getY(), this.getOrientation(), tileHeight);
    }

    @Override
    public WorldArea getWorldArea() {
        return new WorldArea(this.getWorldLocation(), 1, 1);
    }

    @Override
    public boolean isDead() {
        return this.currentHealth <= 0;
    }

    @Override
    public boolean isMoving() {
        return false;
    }

    @Override
    public Polygon[] getPolygons() {
        RSModel model = this.getModel();
        if (model == null) {
            return null;
        }
        int[] x2d = new int[model.getVerticesCount()];
        int[] y2d = new int[model.getVerticesCount()];
        int localX = this.getX();
        int localY = this.getY();
        int tileHeight = Perspective.getTileHeight(Client.instance, new LocalPoint(localX, localY), Client.instance.getPlane());
        Perspective.modelToCanvas(Client.instance, model.getVerticesCount(), localX, localY, tileHeight, this.getOrientation(), model.getVerticesX(), model.getVerticesZ(), model.getVerticesY(), x2d, y2d);
        ArrayList<Polygon> polys = new ArrayList<Polygon>(model.getFaceCount());
        int[] trianglesX = model.getFaceIndices1();
        int[] trianglesY = model.getFaceIndices2();
        int[] trianglesZ = model.getFaceIndices3();
        for (int triangle = 0; triangle < model.getFaceCount(); ++triangle) {
            int[] xx = new int[]{x2d[trianglesX[triangle]], x2d[trianglesY[triangle]], x2d[trianglesZ[triangle]]};
            int[] yy = new int[]{y2d[trianglesX[triangle]], y2d[trianglesY[triangle]], y2d[trianglesZ[triangle]]};
            polys.add(new Polygon(xx, yy, 3));
        }
        return polys.toArray(new Polygon[0]);
    }

    @Override
    @Nullable
    public HeadIcon getOverheadIcon() {
        return null;
    }

    @Override
    @Nullable
    public SkullIcon getSkullIcon() {
        return null;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public int getRSInteracting() {
        return 0;
    }

    @Override
    public String getOverheadText() {
        return null;
    }

    @Override
    public void setOverheadText(String overheadText) {
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int[] getPathX() {
        return this.pathX;
    }

    @Override
    public int[] getPathY() {
        return this.pathY;
    }

    @Override
    public int getAnimation() {
        return this.primarySeqID;
    }

    @Override
    public void setAnimation(int animation) {
        this.primarySeqID = animation;
        System.out.println("set " + this.displayName + " animation too " + animation);
    }

    @Override
    public int getAnimationFrame() {
        return this.primarySeqFrame;
    }

    @Override
    public int getActionFrame() {
        return 0;
    }

    @Override
    public void setAnimationFrame(int frame) {
        this.primarySeqFrame = frame;
    }

    @Override
    public void setActionFrame(int frame) {
        this.primarySeqFrame = frame;
    }

    @Override
    public int getActionFrameCycle() {
        return 0;
    }

    @Override
    public int getGraphic() {
        return this.graphicId;
    }

    @Override
    public void setGraphic(int id) {
        this.graphicId = id;
    }

    @Override
    public int getSpotAnimFrame() {
        return this.graphic_cycle;
    }

    @Override
    public void setSpotAnimFrame(int id) {
        this.graphic_cycle = id;
    }

    @Override
    public int getSpotAnimationFrameCycle() {
        return 0;
    }

    @Override
    public int getIdlePoseAnimation() {
        return 0;
    }

    @Override
    public void setIdlePoseAnimation(int animation) {
    }

    @Override
    public int getPoseAnimation() {
        return 0;
    }

    @Override
    public void setPoseAnimation(int animation) {
    }

    @Override
    public int getPoseFrame() {
        return 0;
    }

    @Override
    public void setPoseFrame(int frame) {
    }

    @Override
    public int getPoseFrameCycle() {
        return 0;
    }

    @Override
    public int getLogicalHeight() {
        return this.height;
    }

    @Override
    public int getOrientation() {
        return this.getTurnDirection();
    }

    @Override
    public int getCurrentOrientation() {
        return this.getTurnDirection();
    }

    @Override
    public RSIterableNodeDeque getHealthBars() {
        return null;
    }

    @Override
    public int[] getHitsplatValues() {
        return new int[0];
    }

    @Override
    public int[] getHitsplatTypes() {
        return new int[0];
    }

    @Override
    public int[] getHitsplatCycles() {
        return new int[0];
    }

    @Override
    public int getIdleRotateLeft() {
        return 0;
    }

    @Override
    public int getIdleRotateRight() {
        return 0;
    }

    @Override
    public int getWalkAnimation() {
        return 0;
    }

    @Override
    public int getWalkRotate180() {
        return 0;
    }

    @Override
    public int getWalkRotateLeft() {
        return 0;
    }

    @Override
    public int getWalkRotateRight() {
        return 0;
    }

    @Override
    public int getRunAnimation() {
        return 0;
    }

    @Override
    public void setDead(boolean dead) {
        this.deadPlayer = dead;
    }

    @Override
    public IterableHashTable<ActorSpotAnim> getSpotAnims() {
        return this.spotAnims;
    }

    @Override
    public boolean hasSpotAnim(int customGfxID) {
        for (EntitySpotAnim graphicObject : this.spotAnims) {
            if (graphicObject.getId() != customGfxID) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeSpotAnim(int hash) {
        Iterator ir = this.spotAnims.iterator();
        while (ir.hasNext()) {
            EntitySpotAnim graphicObject = (EntitySpotAnim)ir.next();
            if (graphicObject.getHash() != (long)hash) continue;
            graphicObject.remove();
            ir.remove();
        }
    }

    @Override
    public void createSpotAnim(int customGfxID, int customGfxID1, int i, int i1) {
        EntitySpotAnim entitySpotAnim = new EntitySpotAnim();
        entitySpotAnim.setId(customGfxID);
        entitySpotAnim.setHeight(i);
        entitySpotAnim.setCycle(Client.instance.getGameCycle() + i1);
        this.spotAnims.insert(entitySpotAnim, entitySpotAnim.getHash());
    }

    @Override
    public int getPathLength() {
        return 0;
    }

    @Override
    public int getOverheadCycle() {
        return 0;
    }

    @Override
    public void setOverheadCycle(int cycle) {
    }

    @Override
    public int getPoseAnimationFrame() {
        return 0;
    }

    @Override
    public void setPoseAnimationFrame(int frame) {
    }

    @Override
    public RSNode getNext() {
        return this.next;
    }

    @Override
    public long getHash() {
        return 0L;
    }

    @Override
    public RSNode getPrevious() {
        return this.previous;
    }

    @Override
    public void onUnlink() {
    }

    @Override
    public RSUsername getRsName() {
        return null;
    }

    @Override
    public int getPlayerId() {
        return this.playerId;
    }

    @Override
    public RSPlayerComposition getPlayerComposition() {
        return null;
    }

    @Override
    public int getCombatLevel() {
        return this.combatLevel;
    }

    @Override
    public int getTotalLevel() {
        return 0;
    }

    @Override
    public int getTeam() {
        return 0;
    }

    @Override
    public boolean isFriendsChatMember() {
        return false;
    }

    @Override
    public boolean isClanMember() {
        return false;
    }

    @Override
    public boolean isFriend() {
        return false;
    }

    @Override
    public boolean isFriended() {
        return false;
    }

    @Override
    public int getRsOverheadIcon() {
        return 0;
    }

    @Override
    public int getRsSkullIcon() {
        return 0;
    }

    @Override
    public int getRSSkillLevel() {
        return 0;
    }

    @Override
    public String[] getActions() {
        return new String[0];
    }

    @Override
    public int getModelHeight() {
        return this.height;
    }

    @Override
    public void setModelHeight(int modelHeight) {
    }

    @Override
    public RSModel getModel() {
        return this.getRotatedModel();
    }

    @Override
    public void draw(int orientation, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z, long hash) {
    }
}

