/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Client;
import com.client.StringUtils;
import java.time.Instant;
import net.runelite.api.ChatMessageType;
import net.runelite.api.MessageNode;
import net.runelite.api.Node;

public class ChatMessage
implements MessageNode {
    private static int chatUid = 0;
    private static int chatId = 0;
    public long chatTime;
    public int type;
    private String playerName;
    private String sender;
    private String message;
    private String runeliteFormattedMessage;
    private String clanTitle;
    private int time;
    public int uid;
    public boolean hovered;

    public ChatMessage() {
        this.clanTitle = Client.instance.clanTitle;
        this.time = Instant.now().getNano();
        this.hovered = false;
        this.uid = chatUid++;
    }

    @Override
    public int getId() {
        return chatId++;
    }

    @Override
    public ChatMessageType getType() {
        return ChatMessageType.of(this.type);
    }

    @Override
    public String getName() {
        return this.playerName;
    }

    @Override
    public void setName(String name) {
        this.playerName = name;
    }

    @Override
    public String getSender() {
        return this.sender;
    }

    @Override
    public void setSender(String sender) {
        this.sender = sender;
    }

    @Override
    public String getValue() {
        return this.message;
    }

    public String getMessage() {
        if (this.runeliteFormattedMessage != null && !this.runeliteFormattedMessage.isEmpty()) {
            return this.runeliteFormattedMessage;
        }
        return this.getValue();
    }

    @Override
    public void setValue(String value) {
        this.message = value;
    }

    @Override
    public String getRuneLiteFormatMessage() {
        return this.runeliteFormattedMessage;
    }

    @Override
    public void setRuneLiteFormatMessage(String runeLiteFormatMessage) {
        this.runeliteFormattedMessage = runeLiteFormatMessage;
    }

    @Override
    public int getTimestamp() {
        return this.time;
    }

    @Override
    public void setTimestamp(int timestamp) {
        this.time = timestamp;
    }

    @Override
    public boolean isFromFriend() {
        long l6 = StringUtils.longForName(this.playerName);
        for (int k6 = 0; k6 < Client.instance.friendsCount; ++k6) {
            if (l6 != Client.instance.friendsListAsLongs[k6] || Client.instance.friendsNodeIDs[k6] == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFromClanMate() {
        String clanname = null;
        for (int j3 = 0; j3 < Client.instance.clanList.length; ++j3) {
            if (Client.instance.clanList[j3] == null) continue;
            clanname = Client.instance.clanList[j3];
            if (clanname.startsWith("<clan")) {
                clanname = clanname.substring(clanname.indexOf(">") + 1, clanname.length());
            }
            if (!clanname.equalsIgnoreCase(this.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Node getNext() {
        return null;
    }

    @Override
    public Node getPrevious() {
        return null;
    }

    @Override
    public void remove() {
    }

    @Override
    public long getHash() {
        return 0L;
    }

    public String toString() {
        return "ChatMessage(chatTime=" + this.chatTime + ", type=" + this.getType() + ", playerName=" + this.playerName + ", sender=" + this.getSender() + ", message=" + this.getMessage() + ", runeliteFormattedMessage=" + this.runeliteFormattedMessage + ", clanTitle=" + this.clanTitle + ", time=" + this.time + ", uid=" + this.uid + ", hovered=" + this.hovered + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.chatTime != other.chatTime) {
            return false;
        }
        ChatMessageType this$type = this.getType();
        ChatMessageType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        if (this.time != other.time) {
            return false;
        }
        if (this.uid != other.uid) {
            return false;
        }
        if (this.hovered != other.hovered) {
            return false;
        }
        String this$playerName = this.playerName;
        String other$playerName = other.playerName;
        if (this$playerName == null ? other$playerName != null : !this$playerName.equals(other$playerName)) {
            return false;
        }
        String this$sender = this.getSender();
        String other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$runeliteFormattedMessage = this.runeliteFormattedMessage;
        String other$runeliteFormattedMessage = other.runeliteFormattedMessage;
        if (this$runeliteFormattedMessage == null ? other$runeliteFormattedMessage != null : !this$runeliteFormattedMessage.equals(other$runeliteFormattedMessage)) {
            return false;
        }
        String this$clanTitle = this.clanTitle;
        String other$clanTitle = other.clanTitle;
        return !(this$clanTitle == null ? other$clanTitle != null : !this$clanTitle.equals(other$clanTitle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        long $chatTime = this.chatTime;
        result2 = result2 * 59 + (int)($chatTime >>> 32 ^ $chatTime);
        ChatMessageType $type = this.getType();
        result2 = result2 * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result2 = result2 * 59 + this.time;
        result2 = result2 * 59 + this.uid;
        result2 = result2 * 59 + (this.hovered ? 79 : 97);
        String $playerName = this.playerName;
        result2 = result2 * 59 + ($playerName == null ? 43 : $playerName.hashCode());
        String $sender = this.getSender();
        result2 = result2 * 59 + ($sender == null ? 43 : $sender.hashCode());
        String $message = this.getMessage();
        result2 = result2 * 59 + ($message == null ? 43 : $message.hashCode());
        String $runeliteFormattedMessage = this.runeliteFormattedMessage;
        result2 = result2 * 59 + ($runeliteFormattedMessage == null ? 43 : $runeliteFormattedMessage.hashCode());
        String $clanTitle = this.clanTitle;
        result2 = result2 * 59 + ($clanTitle == null ? 43 : $clanTitle.hashCode());
        return result2;
    }
}

