/*
 * Decompiled with CFR 0.152.
 */
package com.client;

import com.client.Buffer;
import com.client.Cacheable;
import com.client.sign.Signlink;

public final class Buffer1
extends Cacheable {
    public byte[] payload;
    public int currentPosition;
    public int bitPosition;
    private static final int[] BIT_MASKS = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};

    public void setOffset(int offset) {
        this.currentPosition = offset;
    }

    public String readStrings() {
        int i = this.currentPosition;
        while (this.payload[this.currentPosition++] != 10) {
        }
        return new String(this.payload, i, this.currentPosition - i - 1);
    }

    public int read24Int() {
        this.currentPosition += 3;
        return ((this.payload[this.currentPosition - 3] & 0xFF) << 16) + ((this.payload[this.currentPosition - 2] & 0xFF) << 8) + (this.payload[this.currentPosition - 1] & 0xFF);
    }

    public static Buffer create() {
        Buffer buffer = new Buffer();
        buffer.currentPosition = 0;
        buffer.payload = new byte[5000];
        return buffer;
    }

    public final int readUTriByte() {
        this.currentPosition += 3;
        return (0xFF & this.payload[this.currentPosition - 3] << 16) + (0xFF & this.payload[this.currentPosition - 2] << 8) + (0xFF & this.payload[this.currentPosition - 1]);
    }

    public final int readUTriByte(int i) {
        this.currentPosition += 3;
        return (0xFF & this.payload[this.currentPosition - 3] << 16) + (0xFF & this.payload[this.currentPosition - 2] << 8) + (0xFF & this.payload[this.currentPosition - 1]);
    }

    private Buffer1() {
    }

    public Buffer1(byte[] payload) {
        this.payload = payload;
        this.currentPosition = 0;
    }

    public int readUSmart2() {
        int baseVal = 0;
        int lastVal = 0;
        while ((lastVal = this.readUSmart()) == Short.MAX_VALUE) {
            baseVal += Short.MAX_VALUE;
        }
        return baseVal + lastVal;
    }

    public String readNewString() {
        int i = this.currentPosition;
        while (this.payload[this.currentPosition++] != 0) {
        }
        return new String(this.payload, i, this.currentPosition - i - 1);
    }

    public void writeByte(int value) {
        this.payload[this.currentPosition++] = (byte)value;
    }

    public void writeShort(int value) {
        this.payload[this.currentPosition++] = (byte)(value >> 8);
        this.payload[this.currentPosition++] = (byte)value;
    }

    public void writeTriByte(int value) {
        this.payload[this.currentPosition++] = (byte)(value >> 16);
        this.payload[this.currentPosition++] = (byte)(value >> 8);
        this.payload[this.currentPosition++] = (byte)value;
    }

    public void writeInt(int value) {
        this.payload[this.currentPosition++] = (byte)(value >> 24);
        this.payload[this.currentPosition++] = (byte)(value >> 16);
        this.payload[this.currentPosition++] = (byte)(value >> 8);
        this.payload[this.currentPosition++] = (byte)value;
    }

    public void writeLEInt(int value) {
        this.payload[this.currentPosition++] = (byte)value;
        this.payload[this.currentPosition++] = (byte)(value >> 8);
        this.payload[this.currentPosition++] = (byte)(value >> 16);
        this.payload[this.currentPosition++] = (byte)(value >> 24);
    }

    public void writeLong(long value) {
        try {
            this.payload[this.currentPosition++] = (byte)(value >> 56);
            this.payload[this.currentPosition++] = (byte)(value >> 48);
            this.payload[this.currentPosition++] = (byte)(value >> 40);
            this.payload[this.currentPosition++] = (byte)(value >> 32);
            this.payload[this.currentPosition++] = (byte)(value >> 24);
            this.payload[this.currentPosition++] = (byte)(value >> 16);
            this.payload[this.currentPosition++] = (byte)(value >> 8);
            this.payload[this.currentPosition++] = (byte)value;
        }
        catch (RuntimeException runtimeexception) {
            Signlink.reporterror("14395, 5, " + value + ", " + runtimeexception.toString());
            throw new RuntimeException();
        }
    }

    public void writeString(String text) {
        System.arraycopy(text.getBytes(), 0, this.payload, this.currentPosition, text.length());
        this.currentPosition += text.length();
        this.payload[this.currentPosition++] = 10;
    }

    public void writeBytes(byte[] data2, int offset, int length) {
        for (int index = length; index < length + offset; ++index) {
            this.payload[this.currentPosition++] = data2[index];
        }
    }

    public void writeBytes(int value) {
        this.payload[this.currentPosition - value - 1] = (byte)value;
    }

    public int method440() {
        this.currentPosition += 4;
        return ((this.payload[this.currentPosition - 3] & 0xFF) << 24) + ((this.payload[this.currentPosition - 4] & 0xFF) << 16) + ((this.payload[this.currentPosition - 1] & 0xFF) << 8) + (this.payload[-2] & 0xFF);
    }

    public int readUnsignedByte() {
        return this.payload[this.currentPosition++] & 0xFF;
    }

    public int readShort2() {
        this.currentPosition += 2;
        int i = ((this.payload[this.currentPosition - 2] & 0xFF) << 8) + (this.payload[this.currentPosition - 1] & 0xFF);
        if (i > Short.MAX_VALUE) {
            i -= 65537;
        }
        return i;
    }

    public byte readSignedByte() {
        return this.payload[this.currentPosition++];
    }

    public int readUShort() {
        this.currentPosition += 2;
        return ((this.payload[this.currentPosition - 2] & 0xFF) << 8) + (this.payload[this.currentPosition - 1] & 0xFF);
    }

    public int readShort() {
        this.currentPosition += 2;
        int value = ((this.payload[this.currentPosition - 2] & 0xFF) << 8) + (this.payload[this.currentPosition - 1] & 0xFF);
        if (value > Short.MAX_VALUE) {
            value -= 65536;
        }
        return value;
    }

    public int readTriByte() {
        this.currentPosition += 3;
        return ((this.payload[this.currentPosition - 3] & 0xFF) << 16) + ((this.payload[this.currentPosition - 2] & 0xFF) << 8) + (this.payload[this.currentPosition - 1] & 0xFF);
    }

    public int readInt() {
        this.currentPosition += 4;
        return ((this.payload[this.currentPosition - 4] & 0xFF) << 24) + ((this.payload[this.currentPosition - 3] & 0xFF) << 16) + ((this.payload[this.currentPosition - 2] & 0xFF) << 8) + (this.payload[this.currentPosition - 1] & 0xFF);
    }

    public long readLong() {
        long msi = (long)this.readInt() & 0xFFFFFFFFL;
        long lsi = (long)this.readInt() & 0xFFFFFFFFL;
        return (msi << 32) + lsi;
    }

    public String readString() {
        int index = this.currentPosition;
        while (this.payload[this.currentPosition++] != 10) {
        }
        return new String(this.payload, index, this.currentPosition - index - 1);
    }

    public byte[] readBytes() {
        int index = this.currentPosition;
        while (this.payload[this.currentPosition++] != 10) {
        }
        byte[] data2 = new byte[this.currentPosition - index - 1];
        System.arraycopy(this.payload, index, data2, index - index, this.currentPosition - 1 - index);
        return data2;
    }

    public void readBytes(int offset, int length, byte[] data2) {
        for (int index = length; index < length + offset; ++index) {
            data2[index] = this.payload[this.currentPosition++];
        }
    }

    public void initBitAccess() {
        this.bitPosition = this.currentPosition * 8;
    }

    public int readBits(int amount) {
        int byteOffset = this.bitPosition >> 3;
        int bitOffset = 8 - (this.bitPosition & 7);
        int value = 0;
        this.bitPosition += amount;
        while (amount > bitOffset) {
            value += (this.payload[byteOffset++] & BIT_MASKS[bitOffset]) << amount - bitOffset;
            amount -= bitOffset;
            bitOffset = 8;
        }
        value = amount == bitOffset ? (value += this.payload[byteOffset] & BIT_MASKS[bitOffset]) : (value += this.payload[byteOffset] >> bitOffset - amount & BIT_MASKS[amount]);
        return value;
    }

    public void disableBitAccess() {
        this.currentPosition = (this.bitPosition + 7) / 8;
    }

    public int readSmart() {
        int value = this.payload[this.currentPosition] & 0xFF;
        if (value < 128) {
            return this.readUnsignedByte() - 64;
        }
        return this.readUShort() - 49152;
    }

    public int getSmart() {
        try {
            if (this.currentPosition >= this.payload.length) {
                return this.payload[this.payload.length - 1] & 0xFF;
            }
            int value = this.payload[this.currentPosition] & 0xFF;
            if (value < 128) {
                return this.readUnsignedByte();
            }
            return this.readUShort() - 32768;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.readUShort() - 32768;
        }
    }

    public int readUSmart() {
        int value = this.payload[this.currentPosition] & 0xFF;
        if (value < 128) {
            return this.readUnsignedByte();
        }
        return this.readUShort() - 32768;
    }

    public void writeNegatedByte(int value) {
        this.payload[this.currentPosition++] = (byte)(-value);
    }

    public void writeByteS(int value) {
        this.payload[this.currentPosition++] = (byte)(128 - value);
    }

    public int readUByteA() {
        return this.payload[this.currentPosition++] - 128 & 0xFF;
    }

    public int readNegUByte() {
        return -this.payload[this.currentPosition++] & 0xFF;
    }

    public int readUByteS() {
        return 128 - this.payload[this.currentPosition++] & 0xFF;
    }

    public byte readNegByte() {
        return -this.payload[this.currentPosition++];
    }

    public byte readByteS() {
        return (byte)(128 - this.payload[this.currentPosition++]);
    }

    public void writeLEShort(int value) {
        this.payload[this.currentPosition++] = (byte)value;
        this.payload[this.currentPosition++] = (byte)(value >> 8);
    }

    public void writeShortA(int value) {
        this.payload[this.currentPosition++] = (byte)(value >> 8);
        this.payload[this.currentPosition++] = (byte)(value + 128);
    }

    public void writeLEShortA(int value) {
        this.payload[this.currentPosition++] = (byte)(value + 128);
        this.payload[this.currentPosition++] = (byte)(value >> 8);
    }

    public int readLEUShort() {
        this.currentPosition += 2;
        return ((this.payload[this.currentPosition - 1] & 0xFF) << 8) + (this.payload[this.currentPosition - 2] & 0xFF);
    }

    public int readUShortA() {
        this.currentPosition += 2;
        return ((this.payload[this.currentPosition - 2] & 0xFF) << 8) + (this.payload[this.currentPosition - 1] - 128 & 0xFF);
    }

    public int readLEUShortA() {
        this.currentPosition += 2;
        return ((this.payload[this.currentPosition - 1] & 0xFF) << 8) + (this.payload[this.currentPosition - 2] - 128 & 0xFF);
    }

    public int readLEShort() {
        this.currentPosition += 2;
        int value = ((this.payload[this.currentPosition - 1] & 0xFF) << 8) + (this.payload[this.currentPosition - 2] & 0xFF);
        if (value > Short.MAX_VALUE) {
            value -= 65536;
        }
        return value;
    }

    public int readLEShortA() {
        this.currentPosition += 2;
        int value = ((this.payload[this.currentPosition - 1] & 0xFF) << 8) + (this.payload[this.currentPosition - 2] - 128 & 0xFF);
        if (value > Short.MAX_VALUE) {
            value -= 65536;
        }
        return value;
    }

    public int getIntLittleEndian() {
        this.currentPosition += 4;
        return ((this.payload[this.currentPosition - 4] & 0xFF) << 24) + ((this.payload[this.currentPosition - 3] & 0xFF) << 16) + ((this.payload[this.currentPosition - 2] & 0xFF) << 8) + (this.payload[this.currentPosition - 1] & 0xFF);
    }

    public int readMEInt() {
        this.currentPosition += 4;
        return ((this.payload[this.currentPosition - 2] & 0xFF) << 24) + ((this.payload[this.currentPosition - 1] & 0xFF) << 16) + ((this.payload[this.currentPosition - 4] & 0xFF) << 8) + (this.payload[this.currentPosition - 3] & 0xFF);
    }

    public int readIMEInt() {
        this.currentPosition += 4;
        return ((this.payload[this.currentPosition - 3] & 0xFF) << 24) + ((this.payload[this.currentPosition - 4] & 0xFF) << 16) + ((this.payload[this.currentPosition - 1] & 0xFF) << 8) + (this.payload[this.currentPosition - 2] & 0xFF);
    }

    public void writeReverseDataA(byte[] data2, int length, int offset) {
        for (int index = length + offset - 1; index >= length; --index) {
            this.payload[this.currentPosition++] = (byte)(data2[index] + 128);
        }
    }

    public void readReverseData(byte[] data2, int offset, int length) {
        for (int index = length + offset - 1; index >= length; --index) {
            data2[index] = this.payload[this.currentPosition++];
        }
    }
}

