/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.swt;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import com.sun.glass.ui.swt.SWTApplication;
import com.sun.glass.ui.swt.SWTClipboard;
import java.nio.IntBuffer;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

final class SWTView
extends View {
    Canvas canvas;
    DropTarget dropTarget;
    static Shell hiddenShell;
    long layerID = 0L;

    @Override
    protected void _enableInputMethodEvents(long l, boolean bl) {
    }

    @Override
    protected int _getNativeFrameBuffer(long l) {
        return 0;
    }

    @Override
    protected long _create(Map map) {
        if (hiddenShell == null) {
            hiddenShell = new Shell(Display.getDefault(), 1264);
            Display.getDefault().disposeExec(() -> {
                hiddenShell.dispose();
                hiddenShell = null;
            });
        }
        int n = 34865152;
        this.canvas = SWT.getPlatform().equals("cocoa") ? SWTApplication.createGLCanvas(hiddenShell, n, map) : new Canvas((Composite)hiddenShell, n);
        this.canvas.setData((Object)this);
        Listener listener = event -> this.sendKeyEvent(event);
        int[] nArray = new int[]{1, 2};
        for (int i = 0; i < nArray.length; ++i) {
            this.canvas.addListener(nArray[i], listener);
        }
        Listener listener2 = event -> this.sendMouseEvent(event);
        int[] nArray2 = new int[]{3, 4, 5, 6, 7, 38, 37, 35};
        for (int i = 0; i < nArray2.length; ++i) {
            this.canvas.addListener(nArray2[i], listener2);
        }
        this.canvas.addListener(9, event -> this.notifyRepaint(event.x, event.y, event.width, event.height));
        this.canvas.addListener(11, event -> {
            Rectangle rectangle = this.canvas.getClientArea();
            this.notifyResize(rectangle.width, rectangle.height);
        });
        this.dropTarget = SWTClipboard.createDropTarget((Control)this.canvas);
        return SWTApplication.getHandle((Control)this.canvas);
    }

    @Override
    public int getNativeRemoteLayerId(String string) {
        if (this.layerID != 0L) {
            return (int)this.layerID;
        }
        return (int)this.layerID;
    }

    @Override
    protected long _getNativeView(long l) {
        return l;
    }

    @Override
    protected int _getX(long l) {
        return 0;
    }

    @Override
    protected int _getY(long l) {
        return 0;
    }

    @Override
    protected boolean _close(long l) {
        return false;
    }

    @Override
    protected void _scheduleRepaint(long l) {
        this.canvas.redraw();
    }

    @Override
    protected void _begin(long l) {
        SWTApplication.lockFocus((Control)this.canvas);
    }

    @Override
    protected void _end(long l) {
        SWTApplication.unlockFocus((Control)this.canvas);
    }

    @Override
    protected boolean _enterFullscreen(long l, boolean bl, boolean bl2, boolean bl3) {
        this.canvas.getShell().setFullScreen(true);
        if (this.canvas.getShell().getFullScreen()) {
            this.notifyView(431);
            return true;
        }
        return false;
    }

    @Override
    protected void _exitFullscreen(long l, boolean bl) {
        this.canvas.getShell().setFullScreen(false);
        if (!this.canvas.getShell().getFullScreen()) {
            this.notifyView(432);
        }
    }

    @Override
    protected void _setParent(long l, long l2) {
    }

    @Override
    protected void _uploadPixels(long l, Pixels pixels) {
        int n = pixels.getWidth();
        int n2 = pixels.getHeight();
        int[] nArray = ((IntBuffer)pixels.getPixels()).array();
        PaletteData paletteData = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(n, n2, 32, paletteData);
        imageData.setPixels(0, 0, n * n2, nArray, 0);
        Image image = new Image((Device)this.canvas.getDisplay(), imageData);
        GC gC = new GC((Drawable)this.canvas);
        gC.drawImage(image, 0, 0);
        image.dispose();
        gC.dispose();
    }

    void sendKeyEvent(Event event) {
        View.EventHandler eventHandler = this.getEventHandler();
        if (eventHandler == null) {
            return;
        }
        long l = System.nanoTime();
        int n = SWTApplication.getKeyCode(event);
        int n2 = SWTApplication.getModifiers(event);
        int n3 = event.type == 1 ? 111 : 112;
        char[] cArray = new char[]{event.character};
        eventHandler.handleKeyEvent(this, l, n3, n, cArray, n2);
        if (event.character != '\u0000' && event.type == 1) {
            eventHandler.handleKeyEvent(this, l, 113, n, cArray, n2);
        }
    }

    void sendMouseEvent(Event event) {
        View.EventHandler eventHandler = this.getEventHandler();
        if (eventHandler == null) {
            return;
        }
        long l = System.nanoTime();
        int n = 0;
        switch (event.type) {
            case 3: {
                n = 221;
                if ((this.canvas.getShell().getStyle() & 0x80000) == 0) break;
                this.canvas.forceFocus();
                break;
            }
            case 4: {
                n = 222;
                break;
            }
            case 5: {
                if ((event.stateMask & SWT.BUTTON_MASK) != 0) {
                    n = 223;
                    break;
                }
                n = 224;
                break;
            }
            case 6: {
                n = 225;
                break;
            }
            case 7: {
                n = 226;
                break;
            }
            case 38: {
                n = 228;
                break;
            }
            case 37: {
                n = 228;
                break;
            }
        }
        int n2 = SWTApplication.getButton(event);
        int n3 = SWTApplication.getModifiers(event);
        switch (event.type) {
            case 38: {
                break;
            }
            case 37: {
                Point point = this.canvas.toDisplay(event.x, event.y);
                eventHandler.handleScrollEvent(this, l, event.x, event.y, point.x, point.y, 0.0, event.count, n3, 1, 1, 1, 1, 1.0, 1.0);
                break;
            }
            case 35: {
                boolean bl = false;
                Point point = this.canvas.toControl(event.x, event.y);
                eventHandler.handleMenuEvent(this, point.x, point.y, event.x, event.y, bl);
                break;
            }
            default: {
                boolean bl = false;
                Point point = this.canvas.toDisplay(event.x, event.y);
                eventHandler.handleMouseEvent(this, l, n, n2, event.x, event.y, point.x, point.y, n3, bl, false);
            }
        }
    }

    @Override
    public void notifyDragStart(int n, int n2, int n3, int n4, int n5) {
        super.notifyDragStart(n, n2, n3, n4, n5);
    }

    @Override
    public void notifyDragEnd(int n) {
        super.notifyDragEnd(n);
    }

    @Override
    public int notifyDragEnter(int n, int n2, int n3, int n4, int n5) {
        return super.notifyDragEnter(n, n2, n3, n4, n5);
    }

    @Override
    public int notifyDragOver(int n, int n2, int n3, int n4, int n5) {
        return super.notifyDragOver(n, n2, n3, n4, n5);
    }

    @Override
    public void notifyDragLeave() {
        super.notifyDragLeave();
    }

    @Override
    public int notifyDragDrop(int n, int n2, int n3, int n4, int n5) {
        return super.notifyDragDrop(n, n2, n3, n4, n5);
    }
}

