/*
 * Decompiled with CFR 0.152.
 */
package org.launch;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.launch.download.os.OperatingSystem;

public class Settings {
    private String gameDirectory = System.getProperty("user.home") + "/.RuneFuryLauncher/";
    private OperatingSystem operatingSystem = OperatingSystem.WINDOWS;

    public OperatingSystem getOperatingSystem() {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        System.out.println("Found OS: " + OS);
        OperatingSystem operatingSystem = OS.indexOf("mac") >= 0 || OS.indexOf("darwin") >= 0 ? OperatingSystem.MAC : (OS.indexOf("win") >= 0 ? OperatingSystem.WINDOWS : (OS.indexOf("nux") >= 0 ? OperatingSystem.LINUX : OperatingSystem.ANY));
        return operatingSystem;
    }

    public void setOperatingSystem() {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        System.out.println("Found OS: " + OS);
        this.operatingSystem = OS.indexOf("mac") >= 0 || OS.indexOf("darwin") >= 0 ? OperatingSystem.MAC : (OS.indexOf("win") >= 0 ? OperatingSystem.WINDOWS : (OS.indexOf("nux") >= 0 ? OperatingSystem.LINUX : OperatingSystem.ANY));
    }

    public void launchGame(String folderName, String executableName) {
        File file = new File(this.getGameDirectory() + folderName + "/" + executableName);
        if (file.exists()) {
            file.setExecutable(true, false);
            file.setReadable(true, false);
            file.setWritable(true, false);
        }
        String[] command = new String[]{this.getGameDirectory() + folderName + "/" + executableName, "-jar", this.getGameDirectory() + "CLIENT.jar"};
        try {
            Runtime.getRuntime().exec(command);
            Thread.sleep(150L);
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public String getGameDirectory() {
        return this.gameDirectory;
    }
}

