/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.utils.buffer;

import java.nio.FloatBuffer;
import org.lwjgl.system.MemoryUtil;

public class GpuFloatBuffer {
    private FloatBuffer buffer = MemoryUtil.memAllocFloat(65536);

    public void destroy() {
        if (this.buffer != null) {
            MemoryUtil.memFree(this.buffer);
        }
        this.buffer = null;
    }

    public void put(float texture, float u, float v, float pad) {
        this.buffer.put(texture).put(u).put(v).put(pad);
    }

    public void put(float[] floats) {
        this.buffer.put(floats);
    }

    public void put(FloatBuffer buffer) {
        this.buffer.put(buffer);
    }

    public void flip() {
        this.buffer.flip();
    }

    public void clear() {
        this.buffer.clear();
    }

    public void ensureCapacity(int size) {
        int position;
        int capacity = this.buffer.capacity();
        if (capacity - (position = this.buffer.position()) < size) {
            while ((capacity *= 2) - position < size) {
            }
            FloatBuffer newB = MemoryUtil.memAllocFloat(capacity);
            this.buffer.flip();
            newB.put(this.buffer);
            MemoryUtil.memFree(this.buffer);
            this.buffer = newB;
        }
    }

    public FloatBuffer getBuffer() {
        return this.buffer;
    }
}

