/*
 * Decompiled with CFR 0.152.
 */
package rs117.hd.opengl.shader;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL43C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs117.hd.opengl.shader.ShaderException;
import rs117.hd.opengl.shader.Template;
import rs117.hd.utils.Env;
import rs117.hd.utils.ResourcePath;

public class Shader {
    private static final Logger log = LoggerFactory.getLogger(Shader.class);
    @VisibleForTesting
    final List<Unit> units = new ArrayList<Unit>();
    Pattern NVIDIA_ERROR_REGEX = Pattern.compile("^(\\d+)\\((\\d+)\\) : (.*)");

    public Shader add(int type, String name) {
        this.units.add(new Unit(type, name));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(Template template) throws ShaderException {
        int program;
        block18: {
            program = GL43C.glCreateProgram();
            int[] shaders = new int[this.units.size()];
            int i = 0;
            boolean ok = false;
            try {
                while (i < shaders.length) {
                    Unit unit = this.units.get(i);
                    int shader = GL43C.glCreateShader(unit.type);
                    if (shader == 0) {
                        throw new ShaderException("Unable to create shader of type " + unit.type);
                    }
                    String source2 = template.load(unit.filename);
                    GL43C.glShaderSource(shader, (CharSequence)source2);
                    GL43C.glCompileShader(shader);
                    if (GL43C.glGetShaderi(shader, 35713) != 1) {
                        String err = GL43C.glGetShaderInfoLog(shader);
                        GL43C.glDeleteShader(shader);
                        if (template.includeType == Template.IncludeType.GLSL) {
                            Matcher m3 = this.NVIDIA_ERROR_REGEX.matcher(err);
                            if (m3.find()) {
                                try {
                                    int index = Integer.parseInt(m3.group(1));
                                    int lineNumber = Integer.parseInt(m3.group(2));
                                    String error = m3.group(3);
                                    String include = template.includeList.get(index);
                                    err = String.format("Compile error in '%s' on line %d when compiling shader '%s':\n\n%s\n", include, lineNumber, unit.filename, error);
                                }
                                catch (Exception ex) {
                                    log.error("Error while parsing shader compilation error:", ex);
                                }
                            } else {
                                StringBuilder sb = new StringBuilder();
                                sb.append("Compile error while compiling shader '").append(unit.filename).append("':\n\n").append(err).append("\nIncluded sources: [\n");
                                for (int j = 0; j < template.includeList.size(); ++j) {
                                    String s2 = String.valueOf(j);
                                    sb.append("  ").append(String.join((CharSequence)"", Collections.nCopies(1 + (int)Math.log10(template.includeList.size()) - s2.length(), " "))).append(s2).append(": ").append(template.includeList.get(j)).append("\n");
                                }
                                sb.append("]\n");
                                err = sb.toString();
                            }
                        }
                        throw new ShaderException(err);
                    }
                    GL43C.glAttachShader(program, shader);
                    shaders[i++] = shader;
                }
                GL43C.glLinkProgram(program);
                if (GL43C.glGetProgrami(program, 35714) == 0) {
                    String err = GL43C.glGetProgramInfoLog(program);
                    throw new ShaderException(err);
                }
                ok = true;
                if (!Env.has("RLHD_DUMP_SHADERS")) break block18;
                int[] numFormats = new int[]{0};
                GL43C.glGetIntegerv(34814, numFormats);
                if (numFormats[0] < 1) {
                    log.error("OpenGL driver does not support any binary formats");
                    break block18;
                }
                int[] size = new int[]{0};
                GL43C.glGetProgramiv(program, 34625, size);
                int[] format = new int[]{0};
                ByteBuffer binary = BufferUtils.createByteBuffer(size[0]);
                GL43C.glGetProgramBinary(program, size, format, binary);
                try {
                    String shaderName = this.units.stream().map(Unit::getFilename).collect(Collectors.joining(" + ")) + ".bin";
                    ResourcePath.path("shader-dumps", shaderName).mkdirs().writeByteBuffer(binary);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            finally {
                while (i > 0) {
                    int shader = shaders[--i];
                    GL43C.glDetachShader(program, shader);
                    GL43C.glDeleteShader(shader);
                }
                if (!ok) {
                    GL43C.glDeleteProgram(program);
                }
            }
        }
        return program;
    }

    @VisibleForTesting
    static class Unit {
        private final int type;
        private final String filename;

        public Unit(int type, String filename) {
            this.type = type;
            this.filename = filename;
        }

        public int getType() {
            return this.type;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

