/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.icon.IsHiDpiAware;
import org.pushingpixels.substance.api.icon.SubstanceIconUIResource;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;

@TransitionAware
public class TransitionAwareIcon
implements Icon,
IsHiDpiAware {
    private JComponent comp;
    private TransitionAwareUIDelegate transitionAwareUIDelegate;
    protected Delegate delegate;
    protected ColorSchemeAssociationKindDelegate colorSchemeAssociationKindDelegate;
    protected String uniqueIconTypeId;
    private static LazyResettableHashMap<SubstanceIconUIResource> iconMap = new LazyResettableHashMap("TransitionAwareIcon");
    private int iconWidth;
    private int iconHeight;

    public TransitionAwareIcon(AbstractButton button, Delegate delegate, String uniqueIconTypeId) {
        this(button, button == null ? null : () -> (TransitionAwareUI)((Object)button.getUI()), delegate, null, uniqueIconTypeId);
    }

    public TransitionAwareIcon(JComponent comp, TransitionAwareUIDelegate transitionAwareUIDelegate, Delegate delegate, ColorSchemeAssociationKindDelegate colorSchemeAssociationKindDelegate, String uniqueIconTypeId) {
        this.comp = comp;
        this.transitionAwareUIDelegate = transitionAwareUIDelegate;
        this.delegate = delegate;
        this.colorSchemeAssociationKindDelegate = colorSchemeAssociationKindDelegate;
        this.uniqueIconTypeId = uniqueIconTypeId;
        SubstanceIconUIResource markEnabledIcon = this.delegate.getColorSchemeIcon(SubstanceColorSchemeUtilities.getColorScheme(comp, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.ENABLED));
        this.iconWidth = markEnabledIcon.getIconWidth();
        this.iconHeight = markEnabledIcon.getIconHeight();
    }

    @Override
    public boolean isHiDpiAware() {
        return true;
    }

    private synchronized SubstanceIconUIResource getIconToPaint() {
        StateTransitionTracker stateTransitionTracker = this.transitionAwareUIDelegate.getTransitionAwareUI().getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        ComponentState currState = modelStateInfo.getCurrModelState();
        boolean buttonNeverPainted = SubstanceCoreUtilities.isButtonNeverPainted(this.comp);
        if (buttonNeverPainted && currState.isFacetActive(SubstanceSlices.ComponentStateFacet.ENABLE)) {
            currState = ComponentState.ENABLED;
        }
        SubstanceSlices.ColorSchemeAssociationKind baseAssociationKind = this.colorSchemeAssociationKindDelegate == null ? SubstanceSlices.ColorSchemeAssociationKind.MARK : this.colorSchemeAssociationKindDelegate.getColorSchemeAssociationKind(currState);
        SubstanceColorScheme baseScheme = SubstanceColorSchemeUtilities.getColorScheme(this.comp, baseAssociationKind, currState);
        float baseAlpha = SubstanceColorSchemeUtilities.getAlpha(this.comp, currState);
        HashMapKey keyBase = SubstanceCoreUtilities.getHashKey(this.uniqueIconTypeId, SubstanceSizeUtils.getComponentFontSize(this.comp), baseScheme.getDisplayName(), Float.valueOf(baseAlpha));
        SubstanceIconUIResource layerBase = iconMap.get(keyBase);
        if (layerBase == null) {
            SubstanceIconUIResource baseFullOpacity = this.delegate.getColorSchemeIcon(baseScheme);
            if (baseAlpha == 1.0f) {
                layerBase = baseFullOpacity;
                iconMap.put(keyBase, layerBase);
            } else {
                BufferedImage baseImage = SubstanceCoreUtilities.getBlankImage(baseFullOpacity.getIconWidth(), baseFullOpacity.getIconHeight());
                Graphics2D g2base = baseImage.createGraphics();
                g2base.setComposite(AlphaComposite.SrcOver.derive(baseAlpha));
                baseFullOpacity.paintIcon(this.comp, g2base, 0, 0);
                g2base.dispose();
                layerBase = new SubstanceIconUIResource(baseImage);
                iconMap.put(keyBase, layerBase);
            }
        }
        if (currState.isDisabled() || activeStates.size() == 1 || buttonNeverPainted) {
            return layerBase;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(layerBase.getIconWidth(), layerBase.getIconHeight());
        Graphics2D g2d = result.createGraphics();
        layerBase.paintIcon(this.comp, g2d, 0, 0);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            SubstanceSlices.ColorSchemeAssociationKind associationKind = this.colorSchemeAssociationKindDelegate == null ? SubstanceSlices.ColorSchemeAssociationKind.MARK : this.colorSchemeAssociationKindDelegate.getColorSchemeAssociationKind(activeState);
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(this.comp, associationKind, activeState);
            float alpha = SubstanceColorSchemeUtilities.getAlpha(this.comp, activeState);
            HashMapKey key = SubstanceCoreUtilities.getHashKey(this.uniqueIconTypeId, SubstanceSizeUtils.getComponentFontSize(this.comp), scheme.getDisplayName(), Float.valueOf(alpha));
            SubstanceIconUIResource layer = iconMap.get(key);
            if (layer == null) {
                SubstanceIconUIResource fullOpacity = this.delegate.getColorSchemeIcon(scheme);
                if (alpha == 1.0f) {
                    layer = fullOpacity;
                    iconMap.put(key, layer);
                } else {
                    BufferedImage image = SubstanceCoreUtilities.getBlankImage(fullOpacity.getIconWidth(), fullOpacity.getIconHeight());
                    Graphics2D g2layer = image.createGraphics();
                    g2layer.setComposite(AlphaComposite.SrcOver.derive(alpha));
                    fullOpacity.paintIcon(this.comp, g2layer, 0, 0);
                    g2layer.dispose();
                    layer = new SubstanceIconUIResource(image);
                    iconMap.put(key, layer);
                }
            }
            layer.paintIcon(this.comp, g2d, 0, 0);
        }
        g2d.dispose();
        return new SubstanceIconUIResource(result);
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    @Override
    public void paintIcon(Component c, Graphics g2, int x, int y) {
        this.getIconToPaint().paintIcon(c, g2, x, y);
    }

    public static interface TransitionAwareUIDelegate {
        public TransitionAwareUI getTransitionAwareUI();
    }

    public static interface ColorSchemeAssociationKindDelegate {
        public SubstanceSlices.ColorSchemeAssociationKind getColorSchemeAssociationKind(ComponentState var1);
    }

    public static interface Delegate {
        public SubstanceIconUIResource getColorSchemeIcon(SubstanceColorScheme var1);
    }
}

