/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.icon.SubstanceIconUIResource;
import org.pushingpixels.substance.api.painter.border.FlatBorderPainter;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.contrib.intellij.UIUtil;
import org.pushingpixels.substance.internal.painter.SimplisticFillPainter;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceSplitPaneDivider;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.filters.ColorFilter;
import org.pushingpixels.substance.internal.utils.filters.ColorSchemeFilter;
import org.pushingpixels.substance.internal.utils.filters.GrayscaleFilter;
import org.pushingpixels.substance.internal.utils.filters.TranslucentFilter;

public final class SubstanceImageCreator {
    private static final int[] crayonColors = new int[]{0x800000, 0x808000, 32768, 32896, 128, 0x800080, 0x7F7F7F, 0x808080, 0x804000, 0x408000, 32832, 16512, 0x400080, 0x800040, 0x666666, 0x999999, 0xFF0000, 0xFFFF00, 65280, 65535, 255, 0xFF00FF, 0x4C4C4C, 0xB3B3B3, 0xFF8000, 0x80FF00, 65408, 33023, 0x8000FF, 0xFF0080, 0x333333, 0xCCCCCC, 0xFF6666, 0xFFFF66, 0x66FF66, 0x66FFFF, 0x6666FF, 0xFF66FF, 0x191919, 0xE6E6E6, 0xFFCC66, 0xCCFF66, 0x66FFCC, 0x66CCFF, 0xCC66FF, 0xFF6FCF, 0, 0xFFFFFF};

    public static void paintBorder(Component c, Graphics2D graphics, int x, float y, float width, float height, float radius, SubstanceColorScheme borderScheme) {
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(c);
        graphics.translate((double)x, y);
        float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth() / 2.0f;
        GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(width, height, radius, null, borderDelta);
        float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth();
        boolean skipInnerBorder = c instanceof JTextComponent || SwingUtilities.getAncestorOfClass(CellRendererPane.class, c) != null && SwingUtilities.getAncestorOfClass(JFileChooser.class, c) != null;
        GeneralPath contourInner = skipInnerBorder ? null : SubstanceOutlineUtilities.getBaseOutline(width, height, radius - borderThickness, null, borderThickness + borderDelta);
        borderPainter.paintBorder(graphics, c, width, height, contour, contourInner, borderScheme);
        graphics.translate((double)(-x), -y);
    }

    private static BufferedImage getCheckMark(int dimension, boolean isEnabled, SubstanceColorScheme scheme, float checkMarkVisibility) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(dimension, dimension);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath path = new GeneralPath();
        path.moveTo(0.25f * (float)dimension, 0.5f * (float)dimension);
        path.quadTo(0.37f * (float)dimension, 0.6f * (float)dimension, 0.47f * (float)dimension, 0.8f * (float)dimension);
        path.quadTo(0.55f * (float)dimension, 0.5f * (float)dimension, 0.85f * (float)dimension, 0.0f);
        float xClipStart = 0.15f * (float)dimension;
        float xClipEnd = 0.95f * (float)dimension;
        float xClipRealEnd = xClipStart + (xClipEnd - xClipStart) * checkMarkVisibility;
        graphics.setClip(0, 0, (int)Math.ceil(xClipRealEnd), dimension);
        graphics.setColor(SubstanceColorUtilities.getMarkColor(scheme, isEnabled));
        BasicStroke stroke = new BasicStroke(0.15f * (float)dimension, 1, 1);
        graphics.setStroke(stroke);
        graphics.draw(path);
        return result;
    }

    public static SubstanceIconUIResource getArrowIcon(int fontSize, int direction, SubstanceColorScheme colorScheme) {
        float origWidth = SubstanceSizeUtils.getArrowIconWidth(fontSize);
        float origHeight = SubstanceSizeUtils.getArrowIconHeight(fontSize);
        float width = origWidth;
        float height = origHeight;
        if (direction == 0) {
            height *= 2.0f;
        }
        float strokeWidth = SubstanceSizeUtils.getArrowStrokeWidth(fontSize);
        SubstanceIconUIResource result = new SubstanceIconUIResource(SubstanceImageCreator.getArrow(width, height, strokeWidth, direction, colorScheme));
        int finalWidth = (int)(Math.max(origWidth, origHeight) + 2.0f);
        int finalHeight = (int)(Math.max(origWidth, height) + 2.0f);
        result.setDimension(new Dimension(finalWidth, finalHeight));
        return result;
    }

    public static SubstanceIconUIResource getArrowIcon(float width, float height, float strokeWidth, int direction, SubstanceColorScheme scheme) {
        return new SubstanceIconUIResource(SubstanceImageCreator.getArrow(width, height, strokeWidth, direction, scheme));
    }

    private static BufferedImage getArrow(float width, float height, float strokeWidth, int direction, SubstanceColorScheme scheme) {
        if (direction == 3 || direction == 7) {
            float tmp = width;
            width = height;
            height = tmp;
        }
        BufferedImage arrowImage = SubstanceCoreUtilities.getBlankImage((int)Math.ceil(width), (int)Math.ceil(height));
        Graphics2D graphics = (Graphics2D)arrowImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Color arrowColor = SubstanceColorUtilities.getMarkColor(scheme, true);
        graphics.setColor(arrowColor);
        BasicStroke stroke = new BasicStroke(strokeWidth, 1, 0);
        graphics.setStroke(stroke);
        if (direction == 0) {
            float smallHeight = (height - strokeWidth) / 2.0f;
            BufferedImage top = SubstanceImageCreator.getArrow(width, smallHeight, strokeWidth, 1, scheme);
            BufferedImage bottom = SubstanceImageCreator.getArrow(width, smallHeight, strokeWidth, 5, scheme);
            double factor = UIUtil.getScaleFactor();
            graphics.drawImage(top, 0, 0, (int)((double)top.getWidth() / factor), (int)((double)top.getHeight() / factor), null);
            graphics.drawImage(bottom, 0, (int)((double)height / 2.0), (int)((double)bottom.getWidth() / factor), (int)((double)bottom.getHeight() / factor), null);
            return arrowImage;
        }
        float cushion = strokeWidth / 2.0f;
        GeneralPath gp = new GeneralPath();
        switch (direction) {
            case 5: {
                gp.moveTo(cushion, cushion);
                gp.lineTo(0.5f * width, height - cushion - 1.0f);
                gp.lineTo(width - cushion, cushion);
                break;
            }
            case 1: {
                gp.moveTo(cushion, height - cushion - 1.0f);
                gp.lineTo(0.5f * width, cushion);
                gp.lineTo(width - cushion, height - cushion - 1.0f);
                break;
            }
            case 3: {
                gp.moveTo(cushion, cushion);
                gp.lineTo(width - 1.0f - cushion, 0.5f * height);
                gp.lineTo(cushion, height - cushion);
                break;
            }
            case 7: {
                gp.moveTo(width - 1.0f - cushion, cushion);
                gp.lineTo(cushion, 0.5f * height);
                gp.lineTo(width - 1.0f - cushion, height - cushion);
            }
        }
        graphics.draw(gp);
        return arrowImage;
    }

    public static SubstanceIconUIResource getDoubleArrowIcon(int fontSize, int direction, SubstanceColorScheme colorScheme) {
        float arrowWidth = SubstanceSizeUtils.getArrowIconWidth(fontSize);
        float arrowHeight = SubstanceSizeUtils.getArrowIconHeight(fontSize);
        float arrowStrokeWidth = SubstanceSizeUtils.getDoubleArrowStrokeWidth(fontSize);
        float arrowGap = SubstanceSizeUtils.getSmallDoubleArrowGap(fontSize);
        return SubstanceImageCreator.getDoubleArrowIcon(fontSize, arrowWidth, arrowHeight + arrowGap, arrowGap, arrowStrokeWidth, direction, colorScheme);
    }

    public static SubstanceIconUIResource getDoubleArrowIcon(int fontSize, float fullWidth, float fullHeight, float arrowGap, float strokeWidth, int direction, SubstanceColorScheme colorScheme) {
        boolean toggle = direction == 7 || direction == 3;
        int singleArrowWidth = toggle ? (int)fullHeight : (int)fullWidth;
        int singleArrowHeight = toggle ? (int)(fullWidth - arrowGap) : (int)(fullHeight - arrowGap);
        BufferedImage downArrowImage = SubstanceCoreUtilities.getBlankImage((int)fullWidth, (int)fullHeight);
        BufferedImage singleArrow = SubstanceImageCreator.getArrow(singleArrowWidth, singleArrowHeight, strokeWidth, direction, colorScheme);
        Graphics2D graphics = (Graphics2D)downArrowImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        double scaleFactor = UIUtil.getScaleFactor();
        int arrowHeight = singleArrow.getHeight();
        int arrowWidth = singleArrow.getWidth();
        if (!toggle) {
            graphics.drawImage(singleArrow, 0, 0, (int)((double)arrowWidth / scaleFactor), (int)((double)arrowHeight / scaleFactor), null);
            graphics.drawImage(singleArrow, 0, (int)arrowGap, (int)((double)arrowWidth / scaleFactor), (int)((double)arrowHeight / scaleFactor), null);
        } else {
            graphics.drawImage(singleArrow, 0, 0, (int)((double)arrowWidth / scaleFactor), (int)((double)arrowHeight / scaleFactor), null);
            graphics.drawImage(singleArrow, (int)arrowGap, 0, (int)((double)arrowWidth / scaleFactor), (int)((double)arrowHeight / scaleFactor), null);
        }
        return new SubstanceIconUIResource(downArrowImage);
    }

    public static BufferedImage getRotated(BufferedImage bi, int quadrantClockwise, boolean respectScaleFactorDuringRotation) {
        if (quadrantClockwise == 0) {
            return bi;
        }
        int width = bi.getWidth();
        int height = bi.getHeight();
        if ((quadrantClockwise %= 4) == 1 || quadrantClockwise == 3) {
            width = bi.getHeight();
            height = bi.getWidth();
        }
        double factor = UIUtil.getScaleFactor();
        BufferedImage biRot = SubstanceCoreUtilities.getBlankImage((int)((double)width / factor), (int)((double)height / factor));
        AffineTransform at = null;
        double factorForRotation = respectScaleFactorDuringRotation ? factor : 1.0;
        switch (quadrantClockwise) {
            case 1: {
                at = AffineTransform.getTranslateInstance((double)width / factorForRotation, 0.0);
                at.rotate(1.5707963267948966);
                break;
            }
            case 2: {
                at = AffineTransform.getTranslateInstance((double)width / factorForRotation, (double)height / factorForRotation);
                at.rotate(Math.PI);
                break;
            }
            case 3: {
                at = AffineTransform.getTranslateInstance(0.0, (double)height / factorForRotation);
                at.rotate(-1.5707963267948966);
            }
        }
        Graphics2D rotg = biRot.createGraphics();
        rotg.scale(1.0 / factor, 1.0 / factor);
        if (at != null) {
            rotg.setTransform(at);
        }
        rotg.drawImage(bi, 0, 0, bi.getWidth(), bi.getHeight(), null);
        rotg.dispose();
        return biRot;
    }

    public static Icon toGreyscale(Icon icon) {
        if (icon == null) {
            return null;
        }
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        icon.paintIcon(null, result.getGraphics(), 0, 0);
        SubstanceIconUIResource resultIcon = new SubstanceIconUIResource(new GrayscaleFilter().filter(result, null));
        return resultIcon;
    }

    public static Icon makeTransparent(Component c, Icon icon, double alpha) {
        if (icon == null) {
            return null;
        }
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        icon.paintIcon(c, result.getGraphics(), 0, 0);
        return new SubstanceIconUIResource(new TranslucentFilter(alpha).filter(result, null));
    }

    public static BufferedImage getRadioButton(JComponent component, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter, int dimension, ComponentState componentState, int offsetX, SubstanceColorScheme fillColorScheme, SubstanceColorScheme markColorScheme, SubstanceColorScheme borderColorScheme, float checkMarkVisibility, float alpha) {
        if (!componentState.isActive()) {
            fillPainter = SimplisticSoftBorderReverseFillPainter.INSTANCE;
        }
        float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth();
        Ellipse2D.Float contourBorder = new Ellipse2D.Float(borderDelta / 2.0f, borderDelta / 2.0f, (float)dimension - borderDelta, (float)dimension - borderDelta);
        BufferedImage offBackground = SubstanceCoreUtilities.getBlankImage(dimension + offsetX, dimension);
        Graphics2D graphics = (Graphics2D)offBackground.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics.setComposite(SubstanceImageCreator.getAlphaComposite(alpha));
        graphics.translate(offsetX, 0);
        fillPainter.paintContourBackground(graphics, component, dimension, dimension, contourBorder, false, fillColorScheme, true);
        Ellipse2D.Float contourInner = new Ellipse2D.Float(1.5f * borderDelta, 1.5f * borderDelta, (float)dimension - 3.0f * borderDelta, (float)dimension - 3.0f * borderDelta);
        borderPainter.paintBorder(graphics, component, dimension, dimension, contourBorder, contourInner, borderColorScheme);
        graphics.setComposite(AlphaComposite.SrcOver);
        float rc = (float)dimension / 2.0f;
        float radius = (float)dimension / 4.5f;
        Ellipse2D.Double markOval = new Ellipse2D.Double(rc - radius, rc - radius, 2.0f * radius, 2.0f * radius);
        if ((double)checkMarkVisibility > 0.0) {
            graphics.setComposite(SubstanceImageCreator.getAlphaComposite(alpha * checkMarkVisibility));
            graphics.setColor(SubstanceColorUtilities.getMarkColor(markColorScheme, !componentState.isDisabled()));
            graphics.fill(markOval);
        } else {
            graphics.setComposite(SubstanceImageCreator.getAlphaComposite(alpha * 0.3f));
            graphics.setPaint(new GradientPaint(rc + radius, rc - radius, fillColorScheme.getDarkColor(), rc - radius, rc + radius, fillColorScheme.getLightColor()));
            graphics.fill(markOval);
        }
        graphics.dispose();
        return offBackground;
    }

    private static AlphaComposite getAlphaComposite(float alpha) {
        float finalAlpha = alpha;
        if (finalAlpha < 0.0f) {
            finalAlpha = 0.0f;
        } else if (finalAlpha > 1.0f) {
            finalAlpha = 1.0f;
        }
        return AlphaComposite.getInstance(3, finalAlpha);
    }

    public static BufferedImage getCheckBox(AbstractButton button, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter, int dimension, ComponentState componentState, SubstanceColorScheme fillColorScheme, SubstanceColorScheme markColorScheme, SubstanceColorScheme borderColorScheme, float checkMarkVisibility, boolean isCheckMarkFadingOut, float alpha) {
        int xOffset = SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(button), 2, 9, 1, false);
        int yOffset = xOffset + 1;
        int delta = xOffset;
        float cornerRadius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(button));
        if (dimension <= 10) {
            xOffset = 1;
            yOffset = 2;
            cornerRadius = 2.0f;
        }
        int contourDim = dimension - delta;
        float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth() / 2.0f;
        GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(contourDim, contourDim, cornerRadius, null, borderDelta);
        if (!componentState.isActive()) {
            fillPainter = SimplisticSoftBorderReverseFillPainter.INSTANCE;
        }
        BufferedImage offBackground = SubstanceCoreUtilities.getBlankImage(dimension, dimension);
        Graphics2D graphics = (Graphics2D)offBackground.getGraphics();
        graphics.setComposite(SubstanceImageCreator.getAlphaComposite(alpha));
        graphics.translate(delta - 1, delta - 1);
        fillPainter.paintContourBackground(graphics, button, contourDim, contourDim, contour, false, fillColorScheme, true);
        float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth();
        GeneralPath contourInner = SubstanceOutlineUtilities.getBaseOutline(contourDim, contourDim, cornerRadius - borderThickness, null, borderThickness + borderDelta);
        borderPainter.paintBorder(graphics, button, contourDim, contourDim, contour, contourInner, borderColorScheme);
        graphics.translate(-delta, 1 - delta);
        if ((double)checkMarkVisibility > 0.0) {
            if (isCheckMarkFadingOut) {
                graphics.setComposite(SubstanceImageCreator.getAlphaComposite(alpha * checkMarkVisibility));
                checkMarkVisibility = 1.0f;
            }
            BufferedImage checkMark = SubstanceImageCreator.getCheckMark(dimension - yOffset / 2, !componentState.isDisabled(), markColorScheme, checkMarkVisibility);
            double factor = UIUtil.getScaleFactor();
            graphics.drawImage(checkMark, 1 + 2 * xOffset / 3, dimension < 14 ? 0 : -1, (int)((double)checkMark.getWidth() / factor), (int)((double)checkMark.getHeight() / factor), null);
        }
        return offBackground;
    }

    private static BufferedImage overlayEcho(BufferedImage image, float echoAlpha, Color echoColor, int offsetX, int offsetY) {
        int width = image.getWidth();
        int height = image.getHeight();
        offsetY = 0;
        offsetX = 0;
        BufferedImage echo = new ColorFilter(echoColor).filter(image, null);
        double factor = UIUtil.getScaleFactor();
        int tweakedWidth = (int)((double)width / factor);
        int tweakedHeight = (int)((double)height / factor);
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(tweakedWidth, tweakedHeight);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setComposite(SubstanceImageCreator.getAlphaComposite(0.2f * echoAlpha * echoAlpha * echoAlpha));
        graphics.drawImage(echo, offsetX - 1, offsetY - 1, tweakedWidth, tweakedHeight, null);
        graphics.drawImage(echo, offsetX + 1, offsetY - 1, tweakedWidth, tweakedHeight, null);
        graphics.drawImage(echo, offsetX - 1, offsetY + 1, tweakedWidth, tweakedHeight, null);
        graphics.drawImage(echo, offsetX + 1, offsetY + 1, tweakedWidth, tweakedHeight, null);
        graphics.setComposite(SubstanceImageCreator.getAlphaComposite(0.7f * echoAlpha * echoAlpha * echoAlpha));
        graphics.drawImage(echo, offsetX, offsetY - 1, tweakedWidth, tweakedHeight, null);
        graphics.drawImage(echo, offsetX, offsetY + 1, tweakedWidth, tweakedHeight, null);
        graphics.drawImage(echo, offsetX - 1, offsetY, tweakedWidth, tweakedHeight, null);
        graphics.drawImage(echo, offsetX + 1, offsetY, tweakedWidth, tweakedHeight, null);
        graphics.setComposite(SubstanceImageCreator.getAlphaComposite(1.0f));
        graphics.drawImage(image, 0, 0, tweakedWidth, tweakedHeight, null);
        graphics.dispose();
        return result;
    }

    public static SubstanceIconUIResource getMinimizeIcon(SubstanceColorScheme scheme, SubstanceColorScheme backgroundScheme) {
        int iSize = SubstanceSizeUtils.getTitlePaneIconSize();
        return SubstanceImageCreator.getMinimizeIcon(iSize, scheme, backgroundScheme);
    }

    public static SubstanceIconUIResource getMinimizeIcon(int iSize, SubstanceColorScheme scheme, SubstanceColorScheme backgroundScheme) {
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(iSize, iSize);
        Graphics2D graphics = image.createGraphics();
        int start = iSize / 4 - 2;
        int end = 3 * iSize / 4;
        int size = end - start - 3;
        Color color = SubstanceColorUtilities.getMarkColor(scheme, true);
        graphics.setColor(color);
        graphics.fillRect(start + 2, end - 1, size, 3);
        graphics.dispose();
        Color echoColor = scheme.isDark() ? backgroundScheme.getUltraDarkColor() : backgroundScheme.getUltraLightColor();
        int fgStrength = SubstanceColorUtilities.getColorBrightness(color.getRGB());
        int echoStrength = SubstanceColorUtilities.getColorBrightness(echoColor.getRGB());
        boolean noEcho = Math.abs(fgStrength - echoStrength) < 48;
        return new SubstanceIconUIResource(SubstanceImageCreator.overlayEcho(image, noEcho ? 0.0f : SubstanceColorUtilities.getColorStrength(color), echoColor, 1, 1));
    }

    public static SubstanceIconUIResource getRestoreIcon(SubstanceColorScheme scheme, SubstanceColorScheme backgroundScheme) {
        int iSize = SubstanceSizeUtils.getTitlePaneIconSize();
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(iSize, iSize);
        Graphics2D graphics = image.createGraphics();
        int start = iSize / 4 - 1;
        int end = iSize - start;
        int smallSquareSize = end - start - 3;
        Color color = SubstanceColorUtilities.getMarkColor(scheme, true);
        graphics.setColor(color);
        int mainStartX = start;
        int mainStartY = end - smallSquareSize;
        graphics.fillRect(mainStartX, mainStartY, smallSquareSize, 2);
        graphics.fillRect(mainStartX, mainStartY, 1, smallSquareSize);
        graphics.fillRect(mainStartX + smallSquareSize - 1, mainStartY, 1, smallSquareSize);
        graphics.fillRect(mainStartX, mainStartY + smallSquareSize - 1, smallSquareSize, 1);
        int secondaryStartX = mainStartX + 3;
        int secondaryStartY = mainStartY - 3;
        graphics.fillRect(secondaryStartX, secondaryStartY, smallSquareSize, 2);
        graphics.fillRect(secondaryStartX + smallSquareSize - 1, secondaryStartY, 1, smallSquareSize);
        graphics.fillRect(mainStartX + smallSquareSize + 1, secondaryStartY + smallSquareSize - 1, 2, 1);
        graphics.dispose();
        Color echoColor = scheme.isDark() ? backgroundScheme.getUltraDarkColor() : backgroundScheme.getUltraLightColor();
        int fgStrength = SubstanceColorUtilities.getColorBrightness(color.getRGB());
        int echoStrength = SubstanceColorUtilities.getColorBrightness(echoColor.getRGB());
        boolean noEcho = Math.abs(fgStrength - echoStrength) < 48;
        return new SubstanceIconUIResource(SubstanceImageCreator.overlayEcho(image, noEcho ? 0.0f : SubstanceColorUtilities.getColorStrength(color), echoColor, 1, 1));
    }

    public static SubstanceIconUIResource getMaximizeIcon(SubstanceColorScheme scheme, SubstanceColorScheme backgroundScheme) {
        int iSize = SubstanceSizeUtils.getTitlePaneIconSize();
        return SubstanceImageCreator.getMaximizeIcon(iSize, scheme, backgroundScheme);
    }

    public static SubstanceIconUIResource getMaximizeIcon(int iSize, SubstanceColorScheme scheme, SubstanceColorScheme backgroundScheme) {
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(iSize, iSize);
        Graphics2D graphics = image.createGraphics();
        int start = iSize / 4 - 1;
        int end = iSize - start;
        Color color = SubstanceColorUtilities.getMarkColor(scheme, true);
        graphics.setColor(color);
        graphics.fillRect(start, start, end - start, 2);
        graphics.fillRect(start, start, 1, end - start);
        graphics.fillRect(end - 1, start, 1, end - start);
        graphics.fillRect(start, end - 1, end - start, 1);
        graphics.dispose();
        Color echoColor = scheme.isDark() ? backgroundScheme.getUltraDarkColor() : backgroundScheme.getUltraLightColor();
        int fgStrength = SubstanceColorUtilities.getColorBrightness(color.getRGB());
        int echoStrength = SubstanceColorUtilities.getColorBrightness(echoColor.getRGB());
        boolean noEcho = Math.abs(fgStrength - echoStrength) < 48;
        return new SubstanceIconUIResource(SubstanceImageCreator.overlayEcho(image, noEcho ? 0.0f : SubstanceColorUtilities.getColorStrength(color), echoColor, 1, 1));
    }

    public static SubstanceIconUIResource getCloseIcon(SubstanceColorScheme scheme, SubstanceColorScheme backgroundScheme) {
        return SubstanceImageCreator.getCloseIcon(SubstanceSizeUtils.getTitlePaneIconSize(), scheme, backgroundScheme);
    }

    public static SubstanceIconUIResource getCloseIcon(int iSize, SubstanceColorScheme colorScheme, SubstanceColorScheme backgroundScheme) {
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(iSize, iSize);
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        int start = iSize / 4;
        int end = iSize - start;
        BasicStroke stroke = new BasicStroke(SubstanceSizeUtils.getCloseIconStrokeWidth(iSize), 1, 1);
        graphics.setStroke(stroke);
        Color color = SubstanceColorUtilities.getMarkColor(colorScheme, true);
        graphics.setColor(color);
        graphics.drawLine(start, start, end, end);
        graphics.drawLine(start, end, end, start);
        graphics.dispose();
        Color echoColor = colorScheme.isDark() ? backgroundScheme.getUltraDarkColor() : backgroundScheme.getUltraLightColor();
        int fgStrength = SubstanceColorUtilities.getColorBrightness(color.getRGB());
        int echoStrength = SubstanceColorUtilities.getColorBrightness(echoColor.getRGB());
        boolean noEcho = Math.abs(fgStrength - echoStrength) < 48;
        return new SubstanceIconUIResource(SubstanceImageCreator.overlayEcho(image, noEcho ? 0.0f : SubstanceColorUtilities.getColorStrength(color), echoColor, 1, 1));
    }

    public static void paintRectangularBackground(Component c, Graphics g2, int startX, int startY, int width, int height, SubstanceColorScheme colorScheme, float borderAlpha, boolean isVertical) {
        LinearGradientPaint paint;
        Graphics2D graphics = (Graphics2D)g2.create();
        graphics.translate(startX, startY);
        if (!isVertical) {
            paint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 0.4f, 0.5f, 1.0f}, new Color[]{colorScheme.getUltraLightColor(), colorScheme.getLightColor(), colorScheme.getMidColor(), colorScheme.getUltraLightColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics.setPaint(paint);
            graphics.fillRect(0, 0, width, height);
        } else {
            paint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.4f, 0.5f, 1.0f}, new Color[]{colorScheme.getUltraLightColor(), colorScheme.getLightColor(), colorScheme.getMidColor(), colorScheme.getUltraLightColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics.setPaint(paint);
            graphics.fillRect(0, 0, width, height);
        }
        if (borderAlpha > 0.0f) {
            Graphics2D g2d = (Graphics2D)graphics.create();
            g2d.setComposite(WidgetUtilities.getAlphaComposite(null, borderAlpha, graphics));
            SubstanceImageCreator.paintSimpleBorderAliased(c, g2d, width, height, colorScheme);
            g2d.dispose();
        }
        graphics.dispose();
    }

    public static void paintSimpleBorder(Component c, Graphics2D g2d, float width, float height, SubstanceColorScheme borderColorScheme) {
        float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth();
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(c);
        g2d.setColor(borderPainter.getRepresentativeColor(borderColorScheme));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int joinKind = 1;
        int capKind = 0;
        g2d.setStroke(new BasicStroke(borderThickness, capKind, joinKind));
        g2d.draw(new Rectangle2D.Float(borderThickness / 2.0f, borderThickness / 2.0f, width - borderThickness, height - borderThickness));
    }

    public static void paintSimpleBorderAliased(Component c, Graphics2D g2d, int width, int height, SubstanceColorScheme colorScheme) {
        float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth();
        g2d.setColor(SubstanceColorUtilities.getMidBorderColor(colorScheme));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int joinKind = 0;
        int capKind = 2;
        g2d.setStroke(new BasicStroke(borderThickness, capKind, joinKind));
        g2d.draw(new Rectangle2D.Float(borderThickness / 2.0f, borderThickness / 2.0f, (float)width - borderThickness, (float)height - borderThickness));
    }

    public static void paintRectangularStripedBackground(Component c, Graphics g2, int startX, int startY, int width, int height, SubstanceColorScheme colorScheme, BufferedImage stripeImage, int stripeOffset, float borderAlpha, boolean isVertical) {
        LinearGradientPaint paint;
        Graphics2D graphics = (Graphics2D)g2.create(startX, startY, width, height);
        double scaleFactor = UIUtil.getScaleFactor();
        if (!isVertical) {
            paint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, 0.2f, 0.5f, 0.8f, 1.0f}, new Color[]{colorScheme.getDarkColor(), colorScheme.getLightColor(), colorScheme.getMidColor(), colorScheme.getLightColor(), colorScheme.getDarkColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics.setPaint(paint);
            graphics.fillRect(0, 0, width, height);
            if (stripeImage != null) {
                int stripeSize = stripeImage.getHeight();
                int stripeCount = (int)(scaleFactor * (double)width / (double)stripeSize);
                stripeOffset = (int)((double)stripeOffset % ((double)(2 * stripeSize) * scaleFactor));
                for (int stripe = -2; stripe <= stripeCount; stripe += 2) {
                    int stripePos = (int)((double)(stripe * stripeSize) / scaleFactor + (double)stripeOffset);
                    graphics.drawImage(stripeImage, stripePos, 0, (int)((double)stripeImage.getWidth() / scaleFactor), (int)((double)stripeImage.getHeight() / scaleFactor), null);
                }
            }
        } else {
            paint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.2f, 0.5f, 0.8f, 1.0f}, new Color[]{colorScheme.getDarkColor(), colorScheme.getLightColor(), colorScheme.getMidColor(), colorScheme.getLightColor(), colorScheme.getDarkColor()}, MultipleGradientPaint.CycleMethod.REPEAT);
            graphics.setPaint(paint);
            graphics.fillRect(0, 0, width, height);
            if (stripeImage != null) {
                int stripeSize = stripeImage.getWidth();
                int stripeCount = (int)(scaleFactor * (double)height / (double)stripeSize);
                stripeOffset = (int)((double)stripeOffset % ((double)(2 * stripeSize) * scaleFactor));
                for (int stripe = -2; stripe <= stripeCount; stripe += 2) {
                    int stripePos = (int)((double)(stripe * stripeSize) / scaleFactor + (double)stripeOffset);
                    graphics.drawImage(stripeImage, 0, stripePos, (int)((double)stripeImage.getWidth() / scaleFactor), (int)((double)stripeImage.getHeight() / scaleFactor), null);
                }
            }
        }
        if (borderAlpha > 0.0f) {
            Graphics2D g2d = (Graphics2D)graphics.create();
            g2d.setComposite(WidgetUtilities.getAlphaComposite(null, borderAlpha, graphics));
            SubstanceImageCreator.paintSimpleBorderAliased(c, g2d, width, height, colorScheme);
            g2d.dispose();
        }
        graphics.dispose();
    }

    public static BufferedImage getStripe(int baseSize, Color color) {
        int width = (int)(1.8 * (double)baseSize);
        int height = baseSize;
        BufferedImage intermediate = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)intermediate.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(width - 1 - baseSize, 0);
        polygon.addPoint(width - 1, height - 1);
        polygon.addPoint(baseSize, height - 1);
        graphics.setColor(color);
        graphics.fillPolygon(polygon);
        graphics.drawPolygon(polygon);
        return intermediate;
    }

    public static BufferedImage getDragImage(Component c, SubstanceColorScheme colorScheme, int width, int height, int maxNumberOfStripes) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean isDark = colorScheme.isDark();
        Color back1 = isDark ? colorScheme.getLightColor() : SubstanceColorUtilities.getInterpolatedColor(colorScheme.getLightColor(), colorScheme.getDarkColor(), 0.8);
        Color back2 = isDark ? colorScheme.getExtraLightColor() : SubstanceColorUtilities.getInterpolatedColor(colorScheme.getMidColor(), colorScheme.getDarkColor(), 0.4);
        Color fore = isDark ? colorScheme.getDarkColor() : colorScheme.getUltraLightColor();
        int componentFontSize = SubstanceSizeUtils.getComponentFontSize(c);
        int bumpDotDiameter = SubstanceSizeUtils.getDragBumpDiameter(componentFontSize);
        int bumpCellSize = (int)(1.5 * (double)bumpDotDiameter + 1.0);
        int bumpRows = Math.max(1, height / bumpCellSize - 1);
        int bumpColumns = Math.max(1, (width - 2) / bumpCellSize);
        if (maxNumberOfStripes > 0) {
            if (height > width) {
                bumpColumns = Math.min(bumpColumns, maxNumberOfStripes);
            } else {
                bumpRows = Math.min(bumpRows, maxNumberOfStripes);
            }
        }
        int bumpRowOffset = (height - bumpCellSize * bumpRows) / 2;
        int bumpColOffset = 1 + (width - bumpCellSize * bumpColumns) / 2;
        for (int col = 0; col < bumpColumns; ++col) {
            int cx = bumpColOffset + col * bumpCellSize;
            boolean isEvenCol = col % 2 == 0;
            int offsetY = isEvenCol ? 0 : bumpDotDiameter;
            for (int row = 0; row < bumpRows; ++row) {
                int cy = offsetY + bumpRowOffset + row * bumpCellSize;
                graphics.setColor(fore);
                graphics.fillOval(cx + 1, cy + 1, bumpDotDiameter, bumpDotDiameter);
                graphics.setPaint(new GradientPaint(cx, cy, back1, cx + bumpDotDiameter - 1, cy + bumpDotDiameter - 1, back2));
                graphics.fillOval(cx, cy, bumpDotDiameter, bumpDotDiameter);
            }
        }
        return result;
    }

    public static void paintSplitDividerBumpImage(Graphics g2, SubstanceSplitPaneDivider divider, int x, int y, int width, int height, boolean isHorizontal, SubstanceColorScheme colorScheme) {
        Graphics2D graphics = (Graphics2D)g2.create();
        graphics.translate(x, y);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int componentFontSize = SubstanceSizeUtils.getComponentFontSize(divider);
        int bumpDotDiameter = SubstanceSizeUtils.getBigDragBumpDiameter(componentFontSize);
        int bumpCellSize = (int)(1.5 * (double)bumpDotDiameter + 1.0);
        int bumpRows = isHorizontal ? 1 : Math.max(1, height / bumpCellSize - 1);
        int bumpColumns = isHorizontal ? Math.max(1, (width - 2) / bumpCellSize) : 1;
        int bumpRowOffset = (height - bumpCellSize * bumpRows) / 2;
        int bumpColOffset = 1 + (width - bumpCellSize * bumpColumns) / 2;
        BufferedImage singleDot = SubstanceCoreUtilities.getBlankImage(bumpDotDiameter, bumpDotDiameter);
        Graphics2D dotGraphics = (Graphics2D)singleDot.getGraphics();
        dotGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        dotGraphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Color markColor = SubstanceColorUtilities.getMarkColor(colorScheme, divider.isEnabled());
        dotGraphics.setColor(markColor);
        dotGraphics.fillOval(0, 0, bumpDotDiameter, bumpDotDiameter);
        dotGraphics.setComposite(SubstanceImageCreator.getAlphaComposite(0.4f));
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(divider);
        borderPainter.paintBorder(dotGraphics, divider, bumpDotDiameter, bumpDotDiameter, new Ellipse2D.Float(0.0f, 0.0f, bumpDotDiameter, bumpDotDiameter), null, colorScheme);
        graphics.setComposite(WidgetUtilities.getAlphaComposite(divider, 0.8f, g2));
        double scaleFactor = UIUtil.getScaleFactor();
        for (int col = 0; col < bumpColumns; ++col) {
            int cx = bumpColOffset + col * bumpCellSize;
            for (int row = 0; row < bumpRows; ++row) {
                int cy = bumpRowOffset + row * bumpCellSize + (bumpCellSize - bumpDotDiameter) / 2;
                graphics.drawImage(singleDot, cx, cy, (int)((double)singleDot.getWidth() / scaleFactor), (int)((double)singleDot.getHeight() / scaleFactor), null);
            }
        }
        graphics.dispose();
    }

    public static BufferedImage getResizeGripImage(Component c, SubstanceColorScheme colorScheme, int dimension, boolean isCrowded) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(dimension, dimension);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean isDark = colorScheme.isDark();
        Color back1 = isDark ? colorScheme.getLightColor() : SubstanceColorUtilities.getInterpolatedColor(colorScheme.getLightColor(), colorScheme.getDarkColor(), 0.8);
        Color back2 = isDark ? colorScheme.getExtraLightColor() : SubstanceColorUtilities.getInterpolatedColor(colorScheme.getMidColor(), colorScheme.getDarkColor(), 0.4);
        Color fore = isDark ? colorScheme.getDarkColor() : colorScheme.getUltraLightColor();
        int bumpDotDiameter = SubstanceSizeUtils.getDragBumpDiameter(SubstanceSizeUtils.getComponentFontSize(c));
        int bumpCellSize = (int)(1.5 * (double)bumpDotDiameter + 1.0);
        if (isCrowded) {
            --bumpCellSize;
        }
        int bumpLines = dimension / bumpCellSize;
        int bumpOffset = (dimension - bumpCellSize * bumpLines) / 2;
        for (int col = 0; col < bumpLines; ++col) {
            int cx = bumpOffset + col * bumpCellSize;
            for (int row = bumpLines - col - 1; row < bumpLines; ++row) {
                int cy = bumpOffset + row * bumpCellSize;
                graphics.setColor(fore);
                graphics.fillOval(cx + 1, cy + 1, bumpDotDiameter, bumpDotDiameter);
                graphics.setPaint(new GradientPaint(cx, cy, back1, cx + bumpDotDiameter - 1, cy + bumpDotDiameter - 1, back2));
                graphics.fillOval(cx, cy, bumpDotDiameter, bumpDotDiameter);
            }
        }
        return result;
    }

    public static BufferedImage getTreeIcon(JTree tree, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme, SubstanceColorScheme markScheme, boolean isCollapsed) {
        int fontSize = SubstanceSizeUtils.getComponentFontSize(tree);
        int dim = SubstanceSizeUtils.getTreeIconSize(fontSize);
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(dim, dim);
        Graphics2D graphics = (Graphics2D)result.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        SubstanceFillPainter fillPainter = SimplisticSoftBorderReverseFillPainter.INSTANCE;
        FlatBorderPainter fbp = new FlatBorderPainter();
        float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth() / 2.0f;
        GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(dim, dim, SubstanceSizeUtils.getClassicButtonCornerRadius(dim) / 1.5f, null, borderDelta);
        fillPainter.paintContourBackground(graphics, tree, dim, dim, contour, false, fillScheme, false);
        fbp.paintBorder(graphics, tree, dim, dim, contour, null, borderScheme);
        Color signColor = markScheme.getForegroundColor();
        graphics.setColor(signColor);
        float mid = dim / 2;
        float length = 7 * dim / 12;
        graphics.setStroke(new BasicStroke(1.0f, 2, 1));
        graphics.draw(new Line2D.Float(mid - length / 2.0f, mid, mid + length / 2.0f, mid));
        if (isCollapsed) {
            graphics.draw(new Line2D.Float(mid, mid - length / 2.0f, mid, mid + length / 2.0f));
        }
        return result;
    }

    private static BufferedImage getSingleCrayon(Color mainColor, int width, int height) {
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(width, height);
        int baseTop = (int)(0.2 * (double)height);
        Graphics2D graphics = (Graphics2D)image.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int r = mainColor.getRed();
        int g2 = mainColor.getGreen();
        int b = mainColor.getBlue();
        double lc = 0.8;
        int lr = (int)((double)r + (double)(255 - r) * lc);
        int lg = (int)((double)g2 + (double)(255 - g2) * lc);
        int lb = (int)((double)b + (double)(255 - b) * lc);
        double dc = 0.05;
        int dr = (int)((1.0 - dc) * (double)r);
        int dg = (int)((1.0 - dc) * (double)g2);
        int db = (int)((1.0 - dc) * (double)b);
        Color lightColor = new Color(lr, lg, lb);
        Color darkColor = new Color(dr, dg, db);
        LinearGradientPaint paint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.3f, 0.5f, 0.9f, 1.0f}, new Color[]{lightColor, darkColor, darkColor, lightColor, lightColor}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setPaint(paint);
        graphics.fillRect(0, baseTop, width, height);
        int dbwr = lr;
        int dbwg = lg;
        int dbwb = lb;
        int lbwr = 128 + dr / 4;
        int lbwg = 128 + dg / 4;
        int lbwb = 128 + db / 4;
        Color lightStripeColor = new Color(lbwr, lbwg, lbwb);
        Color darkStripeColor = new Color(dbwr, dbwg, dbwb);
        int stripeTop = (int)(0.35 * (double)height);
        int stripeHeight = (int)(0.04 * (double)height);
        LinearGradientPaint stripePaint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, 0.3f, 0.5f, 0.9f, 1.0f}, new Color[]{lightStripeColor, darkStripeColor, darkStripeColor, lightStripeColor, lightStripeColor}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics.setPaint(stripePaint);
        graphics.fillRect(0, stripeTop, width, stripeHeight);
        graphics.setColor(lightStripeColor);
        graphics.drawRect(0, stripeTop, width - 1, stripeHeight);
        GeneralPath capPath = new GeneralPath();
        capPath.moveTo(0.5f * (float)width - 3.0f, 4.0f);
        capPath.quadTo(0.5f * (float)width, 0.0f, 0.5f * (float)width + 3.0f, 4.0f);
        capPath.lineTo(width - 3, baseTop);
        capPath.lineTo(2.0f, baseTop);
        capPath.lineTo(0.5f * (float)width - 3.0f, 4.0f);
        graphics.setClip(capPath);
        RadialGradientPaint capPaint = new RadialGradientPaint(width / 2, (float)baseTop, baseTop, width / 2, 4 * baseTop / 3, new float[]{0.0f, 0.1f, 1.0f}, new Color[]{mainColor, mainColor, lightColor}, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        graphics.setPaint(capPaint);
        graphics.fillRect(0, 0, width, baseTop);
        graphics.setStroke(new BasicStroke(1.0f, 1, 1));
        graphics.setClip(null);
        graphics.setColor(new Color(64 + dr / 2, 64 + dg / 2, 64 + db / 2, 200));
        graphics.drawRect(0, baseTop, width - 1, height - baseTop - 1);
        graphics.draw(capPath);
        graphics.dispose();
        return image;
    }

    private static int crayonX(int i) {
        return i % 8 * 22 + 4 + i / 8 % 2 * 11;
    }

    private static int crayonY(int i) {
        return i / 8 * 20 + 23;
    }

    public static Image getCrayonsImage() {
        int iw = 195;
        int ih = 208;
        BufferedImage image = SubstanceCoreUtilities.getBlankImage(iw, ih);
        Graphics2D graphics = (Graphics2D)((Image)image).getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics.setColor(new Color(240, 240, 240));
        graphics.fillRect(0, 0, iw, ih);
        double scaleFactor = UIUtil.getScaleFactor();
        for (int i = 0; i < crayonColors.length; ++i) {
            Color crayonColor = new Color(0xFF000000 | crayonColors[i]);
            BufferedImage crayonImage = SubstanceImageCreator.getSingleCrayon(crayonColor, 22, 120);
            graphics.drawImage(crayonImage, SubstanceImageCreator.crayonX(i), SubstanceImageCreator.crayonY(i), (int)((double)crayonImage.getWidth() / scaleFactor), (int)((double)crayonImage.getHeight() / scaleFactor), null);
        }
        graphics.dispose();
        return image;
    }

    public static SubstanceIconUIResource getHexaMarker(int value, SubstanceColorScheme colorScheme) {
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(9, 9);
        value %= 16;
        Color offColor = null;
        Color onColor = null;
        if (colorScheme == null) {
            return new SubstanceIconUIResource(result);
        }
        boolean isDark = colorScheme.isDark();
        offColor = isDark ? SubstanceColorUtilities.getInterpolatedColor(colorScheme.getUltraLightColor(), Color.white, 0.7) : colorScheme.getMidColor().darker();
        onColor = isDark ? SubstanceColorUtilities.getInterpolatedColor(colorScheme.getUltraLightColor(), Color.white, 0.2) : colorScheme.getForegroundColor();
        boolean bit1 = (value & 1) != 0;
        boolean bit2 = (value & 2) != 0;
        boolean bit3 = (value & 4) != 0;
        boolean bit4 = (value & 8) != 0;
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(bit1 ? onColor : offColor);
        graphics.fillOval(5, 5, 4, 4);
        graphics.setColor(bit2 ? onColor : offColor);
        graphics.fillOval(5, 0, 4, 4);
        graphics.setColor(bit3 ? onColor : offColor);
        graphics.fillOval(0, 5, 4, 4);
        graphics.setColor(bit4 ? onColor : offColor);
        graphics.fillOval(0, 0, 4, 4);
        graphics.dispose();
        return new SubstanceIconUIResource(result);
    }

    public static Icon getWatermarkIcon(SubstanceWatermark watermark) {
        int iSize = SubstanceSizeUtils.getTitlePaneIconSize();
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(iSize, iSize);
        Graphics2D graphics = (Graphics2D)result.getGraphics().create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        watermark.previewWatermark(graphics, SubstanceColorSchemeUtilities.METALLIC_SKIN, 0, 0, iSize, iSize);
        graphics.dispose();
        return new SubstanceIconUIResource(result);
    }

    public static Icon getSmallLockIcon(SubstanceColorScheme scheme, Component c) {
        int componentFontSize = SubstanceSizeUtils.getComponentFontSize(c);
        int extraPadding = SubstanceSizeUtils.getExtraPadding(componentFontSize);
        int size = 9 + 2 * extraPadding;
        return SubstanceCortex.GlobalScope.getIconPack().getLockIcon(size, scheme);
    }

    public static BufferedImage getColorSchemeImage(Component comp, Icon original, SubstanceColorScheme colorScheme, float originalBrightnessFactor) {
        int w = original.getIconWidth();
        int h2 = original.getIconHeight();
        if (w == 0 || h2 == 0) {
            return null;
        }
        BufferedImage origImage = SubstanceCoreUtilities.getBlankImage(w, h2);
        Graphics2D g2d = (Graphics2D)origImage.getGraphics().create();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        original.paintIcon(comp, origImage.getGraphics(), 0, 0);
        g2d.dispose();
        BufferedImage result = SubstanceImageCreator.getColorSchemeImage(origImage, colorScheme, originalBrightnessFactor);
        return result;
    }

    public static BufferedImage getColoredImage(Component comp, Icon original, Color color) {
        int w = original.getIconWidth();
        int h2 = original.getIconHeight();
        BufferedImage origImage = SubstanceCoreUtilities.getBlankImage(w, h2);
        Graphics2D g2d = (Graphics2D)origImage.getGraphics().create();
        original.paintIcon(comp, origImage.getGraphics(), 0, 0);
        g2d.dispose();
        BufferedImage result = new ColorFilter(color).filter(origImage, null);
        return result;
    }

    public static BufferedImage getColorSchemeImage(BufferedImage original, SubstanceColorScheme colorScheme, float originalBrightnessFactor) {
        return ColorSchemeFilter.getColorSchemeFilter(colorScheme, originalBrightnessFactor).filter(original, null);
    }

    public static class SimplisticSoftBorderReverseFillPainter
    extends SimplisticFillPainter {
        public static final SubstanceFillPainter INSTANCE = new SimplisticSoftBorderReverseFillPainter();

        private SimplisticSoftBorderReverseFillPainter() {
        }

        @Override
        public String getDisplayName() {
            return "Simplistic Soft Border Reverse";
        }

        @Override
        public Color getTopFillColor(SubstanceColorScheme fillScheme) {
            return super.getBottomFillColor(fillScheme);
        }

        @Override
        public Color getBottomFillColor(SubstanceColorScheme fillScheme) {
            return super.getTopFillColor(fillScheme);
        }
    }
}

