/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.jgoodies.looks;

import java.awt.Component;
import java.awt.Toolkit;
import java.util.Locale;

public final class LookUtils {
    private static final String JAVA_VENDOR = LookUtils.getSystemProperty("java.vendor");
    private static final String JAVA_SPEC_VERSION = LookUtils.getSystemProperty("java.specification.version");
    private static final String OS_NAME = LookUtils.getSystemProperty("os.name");
    private static final String OS_VERSION = LookUtils.getSystemProperty("os.version");
    public static final boolean IS_OS_FREEBSD = LookUtils.startsWithIgnoreCase(OS_NAME, "FreeBSD");
    public static final boolean IS_OS_LINUX = LookUtils.startsWithIgnoreCase(OS_NAME, "Linux");
    public static final boolean IS_OS_OS2 = LookUtils.startsWith(OS_NAME, "OS/2");
    public static final boolean IS_OS_MAC = LookUtils.startsWith(OS_NAME, "Mac");
    public static final boolean IS_OS_WINDOWS = LookUtils.startsWith(OS_NAME, "Windows");
    public static final boolean IS_OS_WINDOWS_MODERN = LookUtils.startsWith(OS_NAME, "Windows") && !LookUtils.startsWith(OS_VERSION, "4.0");
    public static final boolean IS_OS_WINDOWS_95 = LookUtils.startsWith(OS_NAME, "Windows 9") && LookUtils.startsWith(OS_VERSION, "4.0");
    public static final boolean IS_OS_WINDOWS_98 = LookUtils.startsWith(OS_NAME, "Windows 9") && LookUtils.startsWith(OS_VERSION, "4.1");
    public static final boolean IS_OS_WINDOWS_NT = LookUtils.startsWith(OS_NAME, "Windows NT");
    public static final boolean IS_OS_WINDOWS_ME = LookUtils.startsWith(OS_NAME, "Windows") && LookUtils.startsWith(OS_VERSION, "4.9");
    public static final boolean IS_OS_WINDOWS_2000 = LookUtils.startsWith(OS_NAME, "Windows") && LookUtils.startsWith(OS_VERSION, "5.0");
    public static final boolean IS_OS_WINDOWS_XP = LookUtils.startsWith(OS_NAME, "Windows") && LookUtils.startsWith(OS_VERSION, "5.1");
    public static final boolean IS_OS_WINDOWS_VISTA = LookUtils.startsWith(OS_NAME, "Windows") && LookUtils.startsWith(OS_VERSION, "6.0");
    public static final boolean IS_OS_MAC_YOSEMITE = IS_OS_MAC && LookUtils.startsWith(OS_VERSION, "10.10");
    public static final boolean IS_OS_MAC_EL_CAPITAN_OR_LATER = IS_OS_MAC && (LookUtils.startsWith(OS_VERSION, "10.11") || LookUtils.startsWith(OS_VERSION, "10.12") || LookUtils.startsWith(OS_VERSION, "10.13"));
    public static final boolean IS_OS_SOLARIS = LookUtils.startsWith(OS_NAME, "Solaris");
    public static final boolean IS_VENDOR_APPLE = LookUtils.containsIgnoreCase(JAVA_VENDOR, "Apple");
    public static final boolean IS_JAVA_8 = LookUtils.startsWith(JAVA_SPEC_VERSION, "8");
    public static final boolean IS_JAVA_9 = LookUtils.startsWith(JAVA_SPEC_VERSION, "9");
    public static final boolean IS_JAVA_10 = LookUtils.startsWith(JAVA_SPEC_VERSION, "10");
    public static final boolean IS_LOW_RESOLUTION = LookUtils.isLowResolution();

    private LookUtils() {
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static String getSystemProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    public static Boolean getBooleanSystemProperty(String key, String logMessage) {
        String value = LookUtils.getSystemProperty(key, "");
        Boolean result = value.equalsIgnoreCase("false") ? Boolean.FALSE : (value.equalsIgnoreCase("true") ? Boolean.TRUE : null);
        return result;
    }

    public static boolean isTrueColor(Component c) {
        return c.getToolkit().getColorModel().getPixelSize() >= 24;
    }

    public static boolean getToolkitUsesNativeDropShadows() {
        return IS_OS_MAC;
    }

    private static boolean isLowResolution() {
        return Toolkit.getDefaultToolkit().getScreenResolution() < 120;
    }

    private static boolean startsWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }

    private static boolean startsWithIgnoreCase(String str, String prefix) {
        return str != null && str.toUpperCase(Locale.ENGLISH).startsWith(prefix.toUpperCase(Locale.ENGLISH));
    }

    private static boolean containsIgnoreCase(String str, String searchFor) {
        return str != null && str.toUpperCase(Locale.ENGLISH).contains(searchFor.toUpperCase(Locale.ENGLISH));
    }
}

