/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.pf4j.DefaultPluginDescriptor;
import org.pf4j.PluginDescriptor;
import org.pf4j.PluginDescriptorFinder;
import org.pf4j.PluginRuntimeException;
import org.pf4j.util.FileUtils;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestPluginDescriptorFinder
implements PluginDescriptorFinder {
    private static final Logger log = LoggerFactory.getLogger(ManifestPluginDescriptorFinder.class);
    public static final String PLUGIN_ID = "Plugin-Id";
    public static final String PLUGIN_DESCRIPTION = "Plugin-Description";
    public static final String PLUGIN_CLASS = "Plugin-Class";
    public static final String PLUGIN_VERSION = "Plugin-Version";
    public static final String PLUGIN_PROVIDER = "Plugin-Provider";
    public static final String PLUGIN_DEPENDENCIES = "Plugin-Dependencies";
    public static final String PLUGIN_REQUIRES = "Plugin-Requires";
    public static final String PLUGIN_LICENSE = "Plugin-License";

    @Override
    public boolean isApplicable(Path pluginPath) {
        return Files.exists(pluginPath, new LinkOption[0]) && (Files.isDirectory(pluginPath, new LinkOption[0]) || FileUtils.isJarFile(pluginPath));
    }

    @Override
    public PluginDescriptor find(Path pluginPath) {
        Manifest manifest = this.readManifest(pluginPath);
        return this.createPluginDescriptor(manifest);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Manifest readManifest(Path pluginPath) {
        Path manifestPath;
        if (FileUtils.isJarFile(pluginPath)) {
            try (JarFile jar = new JarFile(pluginPath.toFile());){
                Manifest manifest2 = jar.getManifest();
                if (manifest2 != null) {
                    Manifest manifest3 = manifest2;
                    return manifest3;
                }
            }
            catch (IOException e) {
                throw new PluginRuntimeException(e);
            }
        }
        if ((manifestPath = this.getManifestPath(pluginPath)) == null) {
            throw new PluginRuntimeException("Cannot find the manifest path");
        }
        log.debug("Lookup plugin descriptor in '{}'", (Object)manifestPath);
        if (Files.notExists(manifestPath, new LinkOption[0])) {
            throw new PluginRuntimeException("Cannot find '{}' path", manifestPath);
        }
        try (InputStream input = Files.newInputStream(manifestPath, new OpenOption[0]);){
            Manifest manifest = new Manifest(input);
            return manifest;
        }
        catch (IOException e) {
            throw new PluginRuntimeException(e);
        }
    }

    protected Path getManifestPath(Path pluginPath) {
        if (Files.isDirectory(pluginPath, new LinkOption[0])) {
            return FileUtils.findFile(pluginPath, "MANIFEST.MF");
        }
        return null;
    }

    protected PluginDescriptor createPluginDescriptor(Manifest manifest) {
        String version;
        DefaultPluginDescriptor pluginDescriptor = this.createPluginDescriptorInstance();
        Attributes attributes = manifest.getMainAttributes();
        String id = attributes.getValue(PLUGIN_ID);
        pluginDescriptor.setPluginId(id);
        String description = attributes.getValue(PLUGIN_DESCRIPTION);
        if (StringUtils.isNullOrEmpty(description)) {
            pluginDescriptor.setPluginDescription("");
        } else {
            pluginDescriptor.setPluginDescription(description);
        }
        String clazz = attributes.getValue(PLUGIN_CLASS);
        if (StringUtils.isNotNullOrEmpty(clazz)) {
            pluginDescriptor.setPluginClass(clazz);
        }
        if (StringUtils.isNotNullOrEmpty(version = attributes.getValue(PLUGIN_VERSION))) {
            pluginDescriptor.setPluginVersion(version);
        }
        String provider = attributes.getValue(PLUGIN_PROVIDER);
        pluginDescriptor.setProvider(provider);
        String dependencies = attributes.getValue(PLUGIN_DEPENDENCIES);
        pluginDescriptor.setDependencies(dependencies);
        String requires = attributes.getValue(PLUGIN_REQUIRES);
        if (StringUtils.isNotNullOrEmpty(requires)) {
            pluginDescriptor.setRequires(requires);
        }
        pluginDescriptor.setLicense(attributes.getValue(PLUGIN_LICENSE));
        return pluginDescriptor;
    }

    protected DefaultPluginDescriptor createPluginDescriptorInstance() {
        return new DefaultPluginDescriptor();
    }
}

