/*
 * Decompiled with CFR 0.152.
 */
package net.unethicalite.client.minimal;

import ch.qos.logback.classic.Level;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.openosrs.client.OpenOSRS;
import java.applet.Applet;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.SwingUtilities;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.ValueConversionException;
import joptsimple.ValueConverter;
import net.runelite.api.Client;
import net.runelite.api.Constants;
import net.runelite.client.ClassPreloader;
import net.runelite.client.ClientSessionManager;
import net.runelite.client.RuneLite;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.RuntimeConfigLoader;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.game.WorldService;
import net.runelite.client.rs.ClientLoader;
import net.runelite.client.rs.ClientUpdateCheckMode;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.FatalErrorDialog;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.tooltip.TooltipOverlay;
import net.runelite.http.api.RuneLiteAPI;
import net.unethicalite.client.Unethicalite;
import net.unethicalite.client.config.UnethicaliteConfig;
import net.unethicalite.client.managers.MinimalFpsManager;
import net.unethicalite.client.managers.MinimalPluginManager;
import net.unethicalite.client.managers.SettingsManager;
import net.unethicalite.client.minimal.MinimalModule;
import net.unethicalite.client.minimal.ui.MinimalToolbar;
import net.unethicalite.client.minimal.ui.MinimalUI;
import okhttp3.Cache;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MinimalClient {
    private static final Logger log = LoggerFactory.getLogger(MinimalClient.class);
    public static final File CLIENT_DIR = Unethicalite.CLIENT_DIR;
    public static final File CACHE_DIR = new File(CLIENT_DIR, "cache");
    public static final File LOGS_DIR = new File(CLIENT_DIR, "logs");
    public static final File DEFAULT_CONFIG_FILE = new File(CLIENT_DIR, "settings.properties");
    public static final File DATA_DIR = new File(CLIENT_DIR, "data");
    public static final File SCRIPTS_DIR = new File(CLIENT_DIR, "scripts");
    private static final int MAX_OKHTTP_CACHE_SIZE = 0x1400000;
    @Inject
    private EventBus eventBus;
    @Inject
    private ConfigManager configManager;
    @Inject
    private MinimalUI minimalUI;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Provider<TooltipOverlay> tooltipOverlay;
    @Inject
    @Nullable
    private Client client;
    @Inject
    private MinimalToolbar minimalToolbar;
    @Inject
    @Nullable
    private Applet applet;
    @Inject
    private MinimalPluginManager minimalPluginManager;
    @Inject
    private DrawManager drawManager;
    @Inject
    private MinimalFpsManager minimalFpsManager;
    @Inject
    private UnethicaliteConfig minimalConfig;
    @Inject
    private WorldService worldService;
    @Inject
    private ClientSessionManager clientSessionManager;

    public static void main(String[] args2) throws Exception {
        OkHttpClient okHttpClient;
        Locale.setDefault(Locale.ENGLISH);
        OptionParser parser = new OptionParser();
        parser.accepts("developer-mode", "Enable developer tools");
        parser.accepts("debug", "Show extra debugging output");
        parser.accepts("insecure-skip-tls-verification", "Disables TLS verification");
        parser.accepts("jav_config", "jav_config url").withRequiredArg().defaultsTo(RuneLiteProperties.getJavConfig(), (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> proxyInfo = parser.accepts("proxy").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> worldInfo = parser.accepts("world").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec<File> configfile = parser.accepts("runelite", "Use a specified config file").withRequiredArg().withValuesConvertedBy(new ConfigFileConverter()).defaultsTo(DEFAULT_CONFIG_FILE, (File[])new File[0]);
        OptionSet options = SettingsManager.parseArgs(parser, args2);
        if (options.has("debug")) {
            ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
            logger.setLevel(Level.DEBUG);
        }
        if (options.has("proxy")) {
            String[] proxy = options.valueOf(proxyInfo).split(":");
            if (proxy.length >= 2) {
                System.setProperty("socksProxyHost", proxy[0]);
                System.setProperty("socksProxyPort", proxy[1]);
            }
            if (proxy.length >= 4) {
                System.setProperty("java.net.socks.username", proxy[2]);
                System.setProperty("java.net.socks.password", proxy[3]);
                final String user = proxy[2];
                final char[] pass = proxy[3].toCharArray();
                Authenticator.setDefault(new Authenticator(){
                    private final PasswordAuthentication auth;
                    {
                        this.auth = new PasswordAuthentication(user, pass);
                    }

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return this.auth;
                    }
                });
            }
        }
        if (options.has("world")) {
            int world = options.valueOf(worldInfo);
            System.setProperty("cli.world", String.valueOf(world));
        }
        Thread.setDefaultUncaughtExceptionHandler((thread2, throwable) -> {
            log.error("Uncaught exception:", throwable);
            if (throwable instanceof AbstractMethodError) {
                log.error("Classes are out of date; Build with maven again.");
            }
        });
        OpenOSRS.preload();
        RuneLiteAPI.CLIENT = okHttpClient = MinimalClient.buildHttpClient(options.has("insecure-skip-tls-verification"));
        try {
            RuntimeConfigLoader runtimeConfigLoader = new RuntimeConfigLoader(okHttpClient);
            ClientLoader clientLoader = new ClientLoader(okHttpClient, ClientUpdateCheckMode.AUTO, runtimeConfigLoader, (String)options.valueOf("jav_config"));
            new Thread(() -> {
                clientLoader.get();
                ClassPreloader.preload();
            }, "Preloader").start();
            log.info("FluxPk {} (RuneLite version {}, launcher version {}) starting up, args: {}", OpenOSRS.SYSTEM_VERSION, RuneLiteProperties.getVersion() == null ? "unknown" : RuneLiteProperties.getVersion(), RuneLiteProperties.getLauncherVersion(), args2.length == 0 ? "none" : String.join((CharSequence)" ", args2));
            long start = System.currentTimeMillis();
            RuneLite.setInjector(Guice.createInjector(new MinimalModule(options.has("developer-mode"), okHttpClient, clientLoader, options.valueOf(configfile), options)));
            RuneLite.getInjector().getInstance(MinimalClient.class).start(options);
            long end = System.currentTimeMillis();
            RuntimeMXBean rb = ManagementFactory.getRuntimeMXBean();
            long uptime = rb.getUptime();
            log.info("Client initialization took {}ms. Uptime: {}ms", (Object)(end - start), (Object)uptime);
        }
        catch (Exception e) {
            log.error("Failure during startup", e);
            SwingUtilities.invokeLater(() -> new FatalErrorDialog("FluxPk has encountered an unexpected error during startup.").open());
        }
    }

    @VisibleForTesting
    static OkHttpClient buildHttpClient(boolean insecureSkipTlsVerification) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().pingInterval(30L, TimeUnit.SECONDS).addNetworkInterceptor(chain -> {
            Request userAgentRequest = chain.request().newBuilder().header("User-Agent", RuneLite.USER_AGENT).build();
            return chain.proceed(userAgentRequest);
        }).cache(new Cache(new File(CACHE_DIR, "okhttp"), 0x1400000L)).addNetworkInterceptor(chain -> {
            Response res = chain.proceed(chain.request());
            if (res.code() >= 400 && "GET".equals(res.request().method())) {
                res = res.newBuilder().header("Cache-Control", "no-store").build();
            }
            return res;
        });
        if (insecureSkipTlsVerification || RuneLiteProperties.isInsecureSkipTlsVerification()) {
            MinimalClient.setupInsecureTrustManager(builder);
        }
        return builder.build();
    }

    private static void setupInsecureTrustManager(OkHttpClient.Builder okHttpClientBuilder) {
        try {
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            okHttpClientBuilder.sslSocketFactory(sc.getSocketFactory(), trustManager);
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            log.warn("unable to setup insecure trust manager", ex);
        }
    }

    private static void copyJagexCache() {
        Path from = Paths.get(System.getProperty("user.home"), "jagexcache");
        Path to = Paths.get(Unethicalite.getCacheDirectory().getAbsolutePath(), "jagexcache");
        if (Files.exists(to, new LinkOption[0]) || !Files.exists(from, new LinkOption[0])) {
            return;
        }
        log.info("Copying jagexcache from {} to {}", (Object)from, (Object)to);
        try (Stream<Path> stream = Files.walk(from, new FileVisitOption[0]);){
            stream.forEach(source2 -> {
                try {
                    Files.copy(source2, to.resolve(from.relativize((Path)source2)), StandardCopyOption.COPY_ATTRIBUTES);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            log.warn("unable to copy jagexcache", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(OptionSet options) throws Exception {
        boolean isOutdated;
        boolean bl = isOutdated = this.client == null;
        if (!isOutdated) {
            RuneLite.getInjector().injectMembers(this.client);
        }
        if (this.applet != null) {
            MinimalClient.copyJagexCache();
            this.applet.setSize(Constants.GAME_FIXED_SIZE);
            String oldHome = System.setProperty("user.home", Unethicalite.getCacheDirectory().getAbsolutePath());
            try {
                this.applet.init();
            }
            finally {
                System.setProperty("user.home", oldHome);
            }
            this.applet.start();
        }
        this.configManager.load();
        this.minimalToolbar.init();
        this.drawManager.registerEveryFrameListener(this.minimalFpsManager);
        this.minimalFpsManager.reloadConfig(this.minimalConfig.fpsLimit());
        this.eventBus.register(this.minimalToolbar);
        this.eventBus.register(this.minimalPluginManager);
        this.clientSessionManager.start();
        this.eventBus.register(this.clientSessionManager);
        this.minimalUI.init();
        this.eventBus.register(this.minimalUI);
        this.eventBus.register(this.overlayManager);
        this.eventBus.register(this.configManager);
        this.overlayManager.add(this.tooltipOverlay.get());
        this.minimalUI.show();
        if (options.has("script")) {
            SettingsManager.quickLaunch(this.minimalPluginManager, options);
        }
    }

    static {
        System.setProperty("sun.java2d.uiScale", "1.0");
        String launcherVersion = System.getProperty("launcher.version");
        System.setProperty("runelite.launcher.version", launcherVersion == null ? "unknown" : launcherVersion);
        CLIENT_DIR.mkdirs();
        SCRIPTS_DIR.mkdirs();
        DATA_DIR.mkdirs();
    }

    private static class ConfigFileConverter
    implements ValueConverter<File> {
        private ConfigFileConverter() {
        }

        @Override
        public File convert(String fileName) {
            File file = Paths.get(fileName, new String[0]).isAbsolute() || fileName.startsWith("./") || fileName.startsWith(".\\") ? new File(fileName) : new File(CLIENT_DIR, fileName);
            if (!(!file.exists() || file.isFile() && file.canWrite())) {
                throw new ValueConversionException(String.format("File %s is not accessible", file.getAbsolutePath()));
            }
            return file;
        }

        @Override
        public Class<? extends File> valueType() {
            return File.class;
        }

        @Override
        public String valuePattern() {
            return null;
        }
    }
}

