/*
 * Decompiled with CFR 0.152.
 */
package net.unethicalite.api.script.paint;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.RenderableEntity;
import net.unethicalite.api.script.paint.DefaultPaint;
import net.unethicalite.client.devtools.EntityRenderer;
import net.unethicalite.client.minimal.ui.MinimalUI;

@Singleton
public class Paint
extends Overlay {
    private final List<RenderableEntity> overlays = new ArrayList<RenderableEntity>();
    private boolean enabled = false;
    @Inject
    private EntityRenderer entityRenderer;
    public final DefaultPaint tracker = new DefaultPaint();

    @Inject
    public Paint(OverlayManager overlayManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPriority(OverlayPriority.LOW);
        overlayManager.add(this);
    }

    @Override
    public Dimension render(Graphics2D g2) {
        Font font = g2.getFont();
        if (MinimalUI.getFrame() != null) {
            g2.setColor(Color.WHITE);
            g2.setFont(font);
            this.entityRenderer.render(g2);
        }
        if (!this.enabled) {
            return null;
        }
        for (RenderableEntity renderableEntity : this.overlays) {
            renderableEntity.render(g2);
        }
        return null;
    }

    public void submit(RenderableEntity p) {
        this.overlays.add(p);
    }

    public void clear() {
        this.overlays.clear();
        this.tracker.clear();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.submit(this.tracker.getTracker());
        }
    }
}

