/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.cluescrolls.clues.item;

import net.runelite.api.Client;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.client.plugins.cluescrolls.clues.item.ItemRequirement;

public class MultipleOfItemRequirement
implements ItemRequirement {
    private final int itemId;
    private final int quantity;

    public MultipleOfItemRequirement(int itemId, int quantity) {
        this.itemId = itemId;
        this.quantity = quantity;
    }

    @Override
    public boolean fulfilledBy(int itemId) {
        return itemId == this.itemId && this.quantity == 1;
    }

    @Override
    public boolean fulfilledBy(Item[] items) {
        int quantityFound = 0;
        for (Item item : items) {
            if (item.getId() != this.itemId || (quantityFound += item.getQuantity()) < this.quantity) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCollectiveName(Client client) {
        ItemComposition definition = client.getItemComposition(this.itemId);
        if (definition == null) {
            return "N/A";
        }
        return definition.getName() + " x" + this.quantity;
    }
}

