/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import net.runelite.client.RuneLiteProperties;
import net.runelite.client.ui.FatalErrorDialog;
import net.runelite.client.util.LinkBrowser;

public class RuntimeConfig {
    private Map<String, ?> props = Collections.emptyMap();
    private Map<String, String> sysProps = Collections.emptyMap();
    private String outageMessage;
    private Map<String, String> outageLinks;
    private Set<Integer> ignoreDeadNpcs;
    private Set<Integer> forceDeadNpcs;
    private Set<Integer> resetDeadOnChangeNpcs;
    private Set<Integer> forceDeadAnimations;
    private Set<Integer> nonAttackNpcs;

    public boolean showOutageMessage() {
        if (Strings.isNullOrEmpty(this.getOutageMessage())) {
            return false;
        }
        SwingUtilities.invokeLater(() -> {
            FatalErrorDialog fed = new FatalErrorDialog(this.getOutageMessage());
            if (this.getOutageLinks() != null) {
                for (Map.Entry<String, String> e : this.getOutageLinks().entrySet()) {
                    fed.addButton(e.getKey(), () -> LinkBrowser.browse((String)e.getValue()));
                }
            } else {
                fed.addButton("OSRS Twitter", () -> LinkBrowser.browse(RuneLiteProperties.getOSRSTwitterLink()));
            }
            fed.open();
        });
        return true;
    }

    public Map<String, ?> getProps() {
        return this.props;
    }

    public Map<String, String> getSysProps() {
        return this.sysProps;
    }

    public String getOutageMessage() {
        return this.outageMessage;
    }

    public Map<String, String> getOutageLinks() {
        return this.outageLinks;
    }

    public Set<Integer> getIgnoreDeadNpcs() {
        return this.ignoreDeadNpcs;
    }

    public Set<Integer> getForceDeadNpcs() {
        return this.forceDeadNpcs;
    }

    public Set<Integer> getResetDeadOnChangeNpcs() {
        return this.resetDeadOnChangeNpcs;
    }

    public Set<Integer> getForceDeadAnimations() {
        return this.forceDeadAnimations;
    }

    public Set<Integer> getNonAttackNpcs() {
        return this.nonAttackNpcs;
    }

    public void setProps(Map<String, ?> props) {
        this.props = props;
    }

    public void setSysProps(Map<String, String> sysProps) {
        this.sysProps = sysProps;
    }

    public void setOutageMessage(String outageMessage) {
        this.outageMessage = outageMessage;
    }

    public void setOutageLinks(Map<String, String> outageLinks) {
        this.outageLinks = outageLinks;
    }

    public void setIgnoreDeadNpcs(Set<Integer> ignoreDeadNpcs) {
        this.ignoreDeadNpcs = ignoreDeadNpcs;
    }

    public void setForceDeadNpcs(Set<Integer> forceDeadNpcs) {
        this.forceDeadNpcs = forceDeadNpcs;
    }

    public void setResetDeadOnChangeNpcs(Set<Integer> resetDeadOnChangeNpcs) {
        this.resetDeadOnChangeNpcs = resetDeadOnChangeNpcs;
    }

    public void setForceDeadAnimations(Set<Integer> forceDeadAnimations) {
        this.forceDeadAnimations = forceDeadAnimations;
    }

    public void setNonAttackNpcs(Set<Integer> nonAttackNpcs) {
        this.nonAttackNpcs = nonAttackNpcs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuntimeConfig)) {
            return false;
        }
        RuntimeConfig other = (RuntimeConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, ?> this$props = this.getProps();
        Map<String, ?> other$props = other.getProps();
        if (this$props == null ? other$props != null : !((Object)this$props).equals(other$props)) {
            return false;
        }
        Map<String, String> this$sysProps = this.getSysProps();
        Map<String, String> other$sysProps = other.getSysProps();
        if (this$sysProps == null ? other$sysProps != null : !((Object)this$sysProps).equals(other$sysProps)) {
            return false;
        }
        String this$outageMessage = this.getOutageMessage();
        String other$outageMessage = other.getOutageMessage();
        if (this$outageMessage == null ? other$outageMessage != null : !this$outageMessage.equals(other$outageMessage)) {
            return false;
        }
        Map<String, String> this$outageLinks = this.getOutageLinks();
        Map<String, String> other$outageLinks = other.getOutageLinks();
        if (this$outageLinks == null ? other$outageLinks != null : !((Object)this$outageLinks).equals(other$outageLinks)) {
            return false;
        }
        Set<Integer> this$ignoreDeadNpcs = this.getIgnoreDeadNpcs();
        Set<Integer> other$ignoreDeadNpcs = other.getIgnoreDeadNpcs();
        if (this$ignoreDeadNpcs == null ? other$ignoreDeadNpcs != null : !((Object)this$ignoreDeadNpcs).equals(other$ignoreDeadNpcs)) {
            return false;
        }
        Set<Integer> this$forceDeadNpcs = this.getForceDeadNpcs();
        Set<Integer> other$forceDeadNpcs = other.getForceDeadNpcs();
        if (this$forceDeadNpcs == null ? other$forceDeadNpcs != null : !((Object)this$forceDeadNpcs).equals(other$forceDeadNpcs)) {
            return false;
        }
        Set<Integer> this$resetDeadOnChangeNpcs = this.getResetDeadOnChangeNpcs();
        Set<Integer> other$resetDeadOnChangeNpcs = other.getResetDeadOnChangeNpcs();
        if (this$resetDeadOnChangeNpcs == null ? other$resetDeadOnChangeNpcs != null : !((Object)this$resetDeadOnChangeNpcs).equals(other$resetDeadOnChangeNpcs)) {
            return false;
        }
        Set<Integer> this$forceDeadAnimations = this.getForceDeadAnimations();
        Set<Integer> other$forceDeadAnimations = other.getForceDeadAnimations();
        if (this$forceDeadAnimations == null ? other$forceDeadAnimations != null : !((Object)this$forceDeadAnimations).equals(other$forceDeadAnimations)) {
            return false;
        }
        Set<Integer> this$nonAttackNpcs = this.getNonAttackNpcs();
        Set<Integer> other$nonAttackNpcs = other.getNonAttackNpcs();
        return !(this$nonAttackNpcs == null ? other$nonAttackNpcs != null : !((Object)this$nonAttackNpcs).equals(other$nonAttackNpcs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuntimeConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ?> $props = this.getProps();
        result = result * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
        Map<String, String> $sysProps = this.getSysProps();
        result = result * 59 + ($sysProps == null ? 43 : ((Object)$sysProps).hashCode());
        String $outageMessage = this.getOutageMessage();
        result = result * 59 + ($outageMessage == null ? 43 : $outageMessage.hashCode());
        Map<String, String> $outageLinks = this.getOutageLinks();
        result = result * 59 + ($outageLinks == null ? 43 : ((Object)$outageLinks).hashCode());
        Set<Integer> $ignoreDeadNpcs = this.getIgnoreDeadNpcs();
        result = result * 59 + ($ignoreDeadNpcs == null ? 43 : ((Object)$ignoreDeadNpcs).hashCode());
        Set<Integer> $forceDeadNpcs = this.getForceDeadNpcs();
        result = result * 59 + ($forceDeadNpcs == null ? 43 : ((Object)$forceDeadNpcs).hashCode());
        Set<Integer> $resetDeadOnChangeNpcs = this.getResetDeadOnChangeNpcs();
        result = result * 59 + ($resetDeadOnChangeNpcs == null ? 43 : ((Object)$resetDeadOnChangeNpcs).hashCode());
        Set<Integer> $forceDeadAnimations = this.getForceDeadAnimations();
        result = result * 59 + ($forceDeadAnimations == null ? 43 : ((Object)$forceDeadAnimations).hashCode());
        Set<Integer> $nonAttackNpcs = this.getNonAttackNpcs();
        result = result * 59 + ($nonAttackNpcs == null ? 43 : ((Object)$nonAttackNpcs).hashCode());
        return result;
    }

    public String toString() {
        return "RuntimeConfig(props=" + String.valueOf(this.getProps()) + ", sysProps=" + String.valueOf(this.getSysProps()) + ", outageMessage=" + this.getOutageMessage() + ", outageLinks=" + String.valueOf(this.getOutageLinks()) + ", ignoreDeadNpcs=" + String.valueOf(this.getIgnoreDeadNpcs()) + ", forceDeadNpcs=" + String.valueOf(this.getForceDeadNpcs()) + ", resetDeadOnChangeNpcs=" + String.valueOf(this.getResetDeadOnChangeNpcs()) + ", forceDeadAnimations=" + String.valueOf(this.getForceDeadAnimations()) + ", nonAttackNpcs=" + String.valueOf(this.getNonAttackNpcs()) + ")";
    }
}

