/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import org.reactivestreams.Subscriber;

public final class FlowableFromSupplier<T>
extends Flowable<T>
implements Supplier<T> {
    final Supplier<? extends T> supplier;

    public FlowableFromSupplier(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s2) {
        T t;
        DeferredScalarSubscription<T> deferred = new DeferredScalarSubscription<T>(s2);
        s2.onSubscribe(deferred);
        try {
            t = Objects.requireNonNull(this.supplier.get(), "The supplier returned a null value");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            if (deferred.isCancelled()) {
                RxJavaPlugins.onError(ex);
            } else {
                s2.onError(ex);
            }
            return;
        }
        deferred.complete(t);
    }

    @Override
    public T get() throws Throwable {
        return Objects.requireNonNull(this.supplier.get(), "The supplier returned a null value");
    }
}

