/*
 * Decompiled with CFR 0.152.
 */
package com.radiusmarkers;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.radiusmarkers.AttackType;
import com.radiusmarkers.ColourRadiusMarker;
import com.radiusmarkers.PanelFilter;
import com.radiusmarkers.RadiusMarker;
import com.radiusmarkers.RadiusMarkerConfig;
import com.radiusmarkers.RadiusMarkerPluginPanel;
import com.radiusmarkers.RadiusMarkerSceneOverlay;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Radius Markers", description="Highlight NPC radius regions like attack, hunt, max and wander range", tags={"npc", "range", "region", "aggression", "attack", "hunt", "interaction", "max", "retreat", "wander"})
public class RadiusMarkerPlugin
extends Plugin {
    public static final String CONFIG_GROUP = "radiusmarkers";
    private static final String CONFIG_KEY = "markers";
    private static final String PLUGIN_NAME = "Radius Markers";
    private static final String ICON_FILE = "panel_icon.png";
    private static final String DEFAULT_MARKER_NAME = "Marker";
    private static final String UPDATE_MARKER = "Update marker";
    private final List<ColourRadiusMarker> markers = new ArrayList<ColourRadiusMarker>();
    private ColourRadiusMarker renameMarker = null;
    @Inject
    private Client client;
    @Inject
    private RadiusMarkerConfig config;
    @Inject
    private RadiusMarkerSceneOverlay sceneOverlay;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Gson gson;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private ColorPickerManager colourPickerManager;
    private RadiusMarkerPluginPanel pluginPanel;
    private NavigationButton navigationButton;
    private BufferedImage minimapSpriteFixed;
    private BufferedImage minimapSpriteResizeable;
    private Shape minimapClipFixed;
    private Shape minimapClipResizeable;
    private Rectangle minimapRectangle = new Rectangle();

    @Provides
    RadiusMarkerConfig providesConfig(ConfigManager configManager) {
        return configManager.getConfig(RadiusMarkerConfig.class);
    }

    @Override
    protected void startUp() throws Exception {
        this.overlayManager.add(this.sceneOverlay);
        this.loadMarkers();
        this.pluginPanel = new RadiusMarkerPluginPanel(this.client, this, this.config);
        this.pluginPanel.rebuild();
        BufferedImage icon = ImageUtil.loadImageResource(this.getClass(), ICON_FILE);
        this.navigationButton = NavigationButton.builder().tooltip(PLUGIN_NAME).icon(icon).priority(5).panel(this.pluginPanel).build();
        if (!this.config.hideNavButton()) {
            this.clientToolbar.addNavigation(this.navigationButton);
        }
    }

    @Override
    protected void shutDown() throws Exception {
        this.overlayManager.remove(this.sceneOverlay);
        this.markers.clear();
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.pluginPanel = null;
        this.navigationButton = null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals(CONFIG_GROUP)) {
            return;
        }
        if (configChanged.getKey().equals("hideNavButton")) {
            if (this.config.hideNavButton()) {
                this.clientToolbar.removeNavigation(this.navigationButton);
            } else {
                this.clientToolbar.addNavigation(this.navigationButton);
            }
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        MenuAction menuAction;
        int type = event.getType();
        if (type >= 2000) {
            type -= 2000;
        }
        if (MenuAction.EXAMINE_NPC.equals((Object)(menuAction = MenuAction.of(type))) && this.renameMarker != null) {
            int id = event.getIdentifier();
            NPC[] cachedNPCs = this.client.getCachedNPCs();
            NPC npc = cachedNPCs[id];
            if (npc == null || npc.getName() == null) {
                return;
            }
            this.client.createMenuEntry(-1).setOption(UPDATE_MARKER).setTarget(event.getTarget()).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).setIdentifier(event.getIdentifier()).setType(MenuAction.RUNELITE).onClick(this::updateMarkerInfo);
        }
    }

    private void updateMarkerInfo(MenuEntry entry) {
        NPC[] cachedNPCs = this.client.getCachedNPCs();
        NPC npc = cachedNPCs[entry.getIdentifier()];
        if (npc == null || npc.getName() == null || this.renameMarker == null) {
            return;
        }
        this.renameMarker.getPanel().setMarkerText(npc.getName());
        this.renameMarker.getPanel().setNpcId(npc.getId());
    }

    private void loadMarkers() {
        this.markers.clear();
        Collection<RadiusMarker> radiusMarkers = this.getRadiusMarkers();
        if (radiusMarkers != null) {
            List<ColourRadiusMarker> colourRadiusMarkers = this.translateToColourRadiusMarker(radiusMarkers);
            this.markers.addAll(colourRadiusMarkers);
            Collections.sort(this.markers);
        }
    }

    private Collection<RadiusMarker> getRadiusMarkers() {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY);
        if (Strings.isNullOrEmpty(json)) {
            return Collections.emptyList();
        }
        try {
            List loaded = (List)this.gson.fromJson(json, new TypeToken<List<RadiusMarker>>(){}.getType());
            loaded.removeIf(RadiusMarker::isInvalid);
            return loaded;
        }
        catch (JsonSyntaxException | IllegalStateException ignore) {
            JOptionPane.showConfirmDialog(this.pluginPanel, "The radius markers you are trying to load from your config are malformed", "Warning", 2);
            return null;
        }
    }

    private void saveMarkers(Collection<RadiusMarker> markers) {
        if (markers == null || markers.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, CONFIG_KEY);
            return;
        }
        String json = this.gson.toJson(markers);
        this.configManager.setConfiguration(CONFIG_GROUP, CONFIG_KEY, json);
    }

    public String copyMarkers() {
        ArrayList<RadiusMarker> markersCopy = new ArrayList<RadiusMarker>();
        int regionId = this.client.getLocalPlayer() == null ? -1 : this.client.getLocalPlayer().getWorldLocation().getRegionID();
        String searchTerm = this.pluginPanel.getSearchText().toLowerCase();
        PanelFilter filter = this.pluginPanel.getPanelFilter();
        for (ColourRadiusMarker marker : this.markers) {
            if (!marker.getName().toLowerCase().contains(searchTerm) || !(PanelFilter.ALL.equals((Object)filter) || PanelFilter.REGION.equals((Object)filter) && marker.getWorldPoint().getRegionID() == regionId || PanelFilter.VISIBLE.equals((Object)filter) && marker.isVisible()) && (!PanelFilter.INVISIBLE.equals((Object)filter) || marker.isVisible())) continue;
            markersCopy.add(this.translateToRadiusMarker(marker));
        }
        if (markersCopy.isEmpty()) {
            return null;
        }
        return this.gson.toJson(markersCopy);
    }

    public boolean pasteMarkers(String json) {
        List radiusMarkers;
        if (Strings.isNullOrEmpty(json)) {
            return false;
        }
        try {
            radiusMarkers = (List)this.gson.fromJson(json, new TypeToken<List<RadiusMarker>>(){}.getType());
            radiusMarkers.removeIf(RadiusMarker::isInvalid);
        }
        catch (JsonSyntaxException | IllegalStateException ignore) {
            JOptionPane.showConfirmDialog(this.pluginPanel, "The radius markers you are trying to import are malformed", "Warning", 2);
            return false;
        }
        ArrayList<ColourRadiusMarker> outputMarkers = new ArrayList<ColourRadiusMarker>();
        List<ColourRadiusMarker> colourRadiusMarkers = this.translateToColourRadiusMarker(radiusMarkers);
        for (ColourRadiusMarker radiusMarker : colourRadiusMarkers) {
            boolean unique = true;
            for (ColourRadiusMarker marker : this.markers) {
                if (marker.getId() != radiusMarker.getId()) continue;
                unique = false;
                break;
            }
            if (!unique) continue;
            outputMarkers.add(radiusMarker);
        }
        if (outputMarkers.isEmpty()) {
            return false;
        }
        this.markers.addAll(outputMarkers);
        Collections.sort(this.markers);
        this.saveMarkers();
        return true;
    }

    public boolean exclude(NPC npc) {
        return npc == null || npc.getName() == null || npc.getName().isEmpty() || "null".equals(npc.getName());
    }

    private List<ColourRadiusMarker> translateToColourRadiusMarker(Collection<RadiusMarker> markers) {
        if (markers.isEmpty()) {
            return Collections.emptyList();
        }
        return markers.stream().map(ColourRadiusMarker::new).collect(Collectors.toList());
    }

    private RadiusMarker translateToRadiusMarker(ColourRadiusMarker colourRadiusMarker) {
        return new RadiusMarker(colourRadiusMarker.getId(), colourRadiusMarker.getName(), colourRadiusMarker.isVisible(), colourRadiusMarker.isCollapsed(), colourRadiusMarker.getZ(), colourRadiusMarker.getSpawnX(), colourRadiusMarker.getSpawnY(), colourRadiusMarker.getSpawnColour(), colourRadiusMarker.isSpawnVisible(), colourRadiusMarker.getWanderRadius(), colourRadiusMarker.getWanderColour(), colourRadiusMarker.isWanderVisible(), colourRadiusMarker.getMaxRadius(), colourRadiusMarker.getMaxColour(), colourRadiusMarker.isMaxVisible(), colourRadiusMarker.getAggressionColour(), colourRadiusMarker.isAggressionVisible(), colourRadiusMarker.getRetreatInteractionColour(), colourRadiusMarker.isRetreatInteractionVisible(), colourRadiusMarker.getNpcId(), colourRadiusMarker.getAttackRadius(), colourRadiusMarker.getAttackColour(), colourRadiusMarker.getAttackType(), colourRadiusMarker.isAttackVisible(), colourRadiusMarker.getHuntRadius(), colourRadiusMarker.getHuntColour(), colourRadiusMarker.isHuntVisible(), colourRadiusMarker.getInteractionRadius(), colourRadiusMarker.getInteractionColour(), colourRadiusMarker.isInteractionVisible());
    }

    private ColourRadiusMarker findColourRadiusMarker(RadiusMarker radiusMarker) {
        for (ColourRadiusMarker colourRadiusMarker : this.markers) {
            if (!colourRadiusMarker.equals(radiusMarker)) continue;
            return colourRadiusMarker;
        }
        return null;
    }

    public void saveMarkers() {
        ArrayList<RadiusMarker> radiusMarkers = new ArrayList<RadiusMarker>();
        for (ColourRadiusMarker cm : this.markers) {
            radiusMarkers.add(this.translateToRadiusMarker(cm));
        }
        this.saveMarkers(radiusMarkers);
    }

    public ColourRadiusMarker addMarker() {
        if (this.client.getLocalPlayer() == null) {
            return null;
        }
        WorldPoint worldPoint = WorldPoint.fromLocalInstance(this.client, this.client.getLocalPlayer().getLocalLocation());
        return this.findColourRadiusMarker(this.addMarker(worldPoint));
    }

    public RadiusMarker addMarker(WorldPoint worldPoint) {
        RadiusMarker marker = new RadiusMarker(Instant.now().toEpochMilli(), "Marker " + (this.markers.size() + 1), true, false, worldPoint.getPlane(), worldPoint.getX(), worldPoint.getY(), this.config.defaultColourSpawn(), true, this.config.defaultRadiusWander(), this.config.defaultColourWander(), true, this.config.defaultRadiusMax(), this.config.defaultColourMax(), true, this.config.defaultColourAggression(), true, this.config.defaultColourRetreatInteraction(), false, 0, this.config.defaultRadiusAttack(), this.config.defaultColourAttack(), AttackType.MELEE, true, this.config.defaultRadiusHunt(), this.config.defaultColourHunt(), false, this.config.defaultRadiusInteraction(), this.config.defaultColourInteraction(), false);
        ArrayList<RadiusMarker> radiusMarkers = new ArrayList<RadiusMarker>(this.getRadiusMarkers());
        if (!radiusMarkers.contains(marker)) {
            radiusMarkers.add(marker);
        }
        this.saveMarkers(radiusMarkers);
        this.loadMarkers();
        this.pluginPanel.rebuild();
        return marker;
    }

    public void removeMarker(ColourRadiusMarker colourRadiusMarker) {
        RadiusMarker radiusMarker = this.translateToRadiusMarker(colourRadiusMarker);
        ArrayList<RadiusMarker> radiusMarkers = new ArrayList<RadiusMarker>(this.getRadiusMarkers());
        radiusMarkers.remove(radiusMarker);
        this.saveMarkers(radiusMarkers);
        this.loadMarkers();
        this.pluginPanel.rebuild();
    }

    public Collection<WorldPoint> getInstanceWorldPoints(WorldPoint worldPointTemplate) {
        if (!this.client.isInInstancedRegion()) {
            return Collections.singleton(worldPointTemplate);
        }
        return WorldPoint.toLocalInstance(this.client, worldPointTemplate);
    }

    List<ColourRadiusMarker> getMarkers() {
        return this.markers;
    }

    void setRenameMarker(ColourRadiusMarker renameMarker) {
        this.renameMarker = renameMarker;
    }

    public ColorPickerManager getColourPickerManager() {
        return this.colourPickerManager;
    }
}

