/*
 * Decompiled with CFR 0.152.
 */
package com.openosrs.client.ui;

import com.openosrs.client.ui.components.InfoPanel;
import com.openosrs.client.ui.components.MessagePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenOSRSSplashScreen
extends JFrame {
    private static final Logger log = LoggerFactory.getLogger(OpenOSRSSplashScreen.class);
    private static OpenOSRSSplashScreen INSTANCE;
    public static final Dimension FRAME_SIZE;
    private final MessagePanel messagePanel = new MessagePanel();

    private OpenOSRSSplashScreen() {
        this.setTitle("FluxPk");
        this.setDefaultCloseOperation(2);
        this.setSize(FRAME_SIZE);
        this.setLayout(new BorderLayout());
        this.setUndecorated(true);
        this.setIconImage(ClientUI.ICON);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setPreferredSize(FRAME_SIZE);
        panel.add((Component)new InfoPanel(), "East");
        panel.add((Component)this.messagePanel, "West");
        this.setContentPane(panel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public static boolean showing() {
        return INSTANCE != null;
    }

    public static void setError(String title, String content) {
        if (INSTANCE != null) {
            INSTANCE.setErrorInstance(title, content);
        }
    }

    private void setErrorInstance(String title, String content) {
        this.messagePanel.setMessageContent(content);
        this.messagePanel.setMessageTitle("Error!");
        this.messagePanel.getBarLabel().setText(title);
        this.messagePanel.getBar().setBackground(ColorScheme.PROGRESS_ERROR_COLOR.darker());
        this.messagePanel.getBar().setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        this.getContentPane().revalidate();
        this.getContentPane().repaint();
    }

    private void setBarText(String text) {
        JProgressBar bar = this.messagePanel.getBar();
        bar.setString(text);
        bar.setStringPainted(text != null);
        bar.revalidate();
        bar.repaint();
    }

    private void setMessage(String msg, double value) {
        this.messagePanel.getBarLabel().setText(msg);
        this.messagePanel.getBar().setMaximum(1000);
        this.messagePanel.getBar().setValue((int)(value * 1000.0));
        this.setBarText(null);
        this.getContentPane().revalidate();
        this.getContentPane().repaint();
    }

    public static void init() {
        SwingUtilities.invokeLater(() -> {
            try {
                INSTANCE = new OpenOSRSSplashScreen();
            }
            catch (Exception e) {
                log.warn("Unable to start splash screen", e);
            }
        });
    }

    public static void close() {
        SwingUtilities.invokeLater(() -> {
            if (INSTANCE == null) {
                return;
            }
            INSTANCE.setVisible(false);
            INSTANCE.dispose();
            INSTANCE = null;
        });
    }

    public static void stage(double startProgress, double endProgress, String progressText, int done, int total) {
        String progress = done + " / " + total;
        OpenOSRSSplashScreen.stage(startProgress + (endProgress - startProgress) * (double)done / (double)total, progressText + " " + progress);
    }

    public static void stage(double overallProgress, String progressText) {
        if (INSTANCE != null) {
            INSTANCE.setMessage(progressText, overallProgress);
        }
    }

    public MessagePanel getMessagePanel() {
        return this.messagePanel;
    }

    static {
        FRAME_SIZE = new Dimension(600, 350);
    }
}

