/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.util;

import java.awt.Color;

public enum RaidMode {
    ENTRY_MODE(0, 149, new Color(255, 208, 73)),
    NORMAL(150, 299, new Color(60, 79, 144)),
    EXPERT_MODE(300, Integer.MAX_VALUE, new Color(190, 38, 51));

    private final int minRaidLevel;
    private final int maxRaidLevel;
    private final Color color;

    public static RaidMode forRaidLevel(int raidLevel) {
        for (RaidMode mode : RaidMode.values()) {
            if (mode.minRaidLevel > raidLevel || raidLevel > mode.maxRaidLevel) continue;
            return mode;
        }
        throw new IllegalArgumentException("No raid mode exists for raid level " + raidLevel);
    }

    private RaidMode(int minRaidLevel, int maxRaidLevel, Color color) {
        this.minRaidLevel = minRaidLevel;
        this.maxRaidLevel = maxRaidLevel;
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }
}

