/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.scabaras.panel;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.scabaras.ScabarasHelperMode;
import com.duckblade.osrs.toa.features.scabaras.panel.ScabarasPanel;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidRoom;
import com.duckblade.osrs.toa.util.RaidState;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.util.ImageUtil;

@Singleton
public class ScabarasPanelManager
implements PluginLifecycleComponent {
    private static final BufferedImage PANEL_ICON = ImageUtil.loadImageResource(ScabarasPanelManager.class, "icon.png");
    private final ClientToolbar clientToolbar;
    private final ScabarasPanel scabarasPanel;
    private NavigationButton navButton;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState currentState) {
        return config.scabarasHelperMode() == ScabarasHelperMode.SIDE_PANEL && currentState.getCurrentRoom() == RaidRoom.SCABARAS;
    }

    @Override
    public void startUp() {
        if (this.navButton == null) {
            this.navButton = NavigationButton.builder().icon(PANEL_ICON).panel(this.scabarasPanel).priority(999).tooltip("Scabaras Tile Puzzle Helper").build();
        }
        this.openPanel();
    }

    @Override
    public void shutDown() {
        this.removePanel();
    }

    private void openPanel() {
        this.clientToolbar.addNavigation(this.navButton);
        SwingUtilities.invokeLater(() -> this.clientToolbar.openPanel(this.navButton));
    }

    private void removePanel() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Inject
    public ScabarasPanelManager(ClientToolbar clientToolbar, ScabarasPanel scabarasPanel) {
        this.clientToolbar = clientToolbar;
        this.scabarasPanel = scabarasPanel;
    }
}

