/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.pointstracker;

public final class UniqueChanceCalculator {
    private static final int BASE_RATE_UNIQUE = 10500;
    private static final int MODIFIER_RAID_LEVEL_UNIQUE = 20;
    private static final int BASE_RATE_PET = 350000;
    private static final int MODIFIER_RAID_LEVEL_PET = 700;
    private static final int RAID_LEVEL_REDUCE_FLOOR = 400;
    private static final double RAID_LEVEL_REDUCE_FACTOR = 0.3333333333333333;
    private static final int RAID_LEVEL_MAX = 550;
    private static final double MAX_RATE_UNIQUE = 55.0;

    public static double getUniqueChance(int raidLevel, int points) {
        return UniqueChanceCalculator.getChance(raidLevel, points, 10500, 20);
    }

    public static double getPetChance(int raidLevel, int points) {
        return UniqueChanceCalculator.getChance(raidLevel, points, 350000, 700);
    }

    private static double getChance(int raidLevel, int points, int baseRate, int modifier) {
        int raidLevelModifier = modifier * Math.min(raidLevel, 400);
        if (raidLevel > 400) {
            raidLevelModifier = (int)((double)raidLevelModifier + (double)((Math.min(raidLevel, 550) - 400) * modifier) * 0.3333333333333333);
        }
        double denominator = baseRate - raidLevelModifier;
        return Math.max(0.0, Math.min(55.0, (double)points / denominator));
    }

    private UniqueChanceCalculator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

