/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.pointstracker;

import com.duckblade.osrs.toa.TombsOfAmascutConfig;
import com.duckblade.osrs.toa.features.pointstracker.PartyPointsTracker;
import com.duckblade.osrs.toa.features.pointstracker.UniqueChanceCalculator;
import com.duckblade.osrs.toa.module.PluginLifecycleComponent;
import com.duckblade.osrs.toa.util.RaidState;
import com.duckblade.osrs.toa.util.RaidStateChanged;
import com.duckblade.osrs.toa.util.RaidStateTracker;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PointsTracker
implements PluginLifecycleComponent {
    private static final Logger log = LoggerFactory.getLogger(PointsTracker.class);
    static final NumberFormat POINTS_FORMAT = NumberFormat.getInstance();
    static final NumberFormat PERCENT_FORMAT = new DecimalFormat("#.##%");
    private static final String START_MESSAGE = "You enter the Tombs of Amascut";
    private static final String DEATH_MESSAGE = "You have died";
    private static final String ROOM_FAIL_MESSAGE = "Your party failed to complete";
    private static final String ROOM_FINISH_MESSAGE = "Challenge complete";
    private static final int BASE_POINTS = 5000;
    private static final int MAX_ROOM_POINTS = 20000;
    private static final int MAX_TOTAL_POINTS = 69000;
    private static final int ANIMATION_ID_WARDEN_DOWN = 9670;
    private static final Map<Integer, Double> DAMAGE_POINTS_FACTORS = ImmutableMap.builder().put(11770, 0.0).put(11771, 0.0).put(11772, 0.0).put(11782, 0.0).put(11783, 0.0).put(11709, 1.2).put(11712, 1.2).put(11710, 1.2).put(11713, 1.2).put(11711, 1.2).put(11714, 1.2).put(11715, 1.2).put(11716, 1.2).put(11717, 1.2).put(11718, 1.2).put(11778, 2.0).put(11779, 2.0).put(11780, 2.0).put(10680, 1.5).put(11730, 1.5).put(11732, 1.5).put(11733, 1.5).put(11725, 0.5).put(11724, 0.5).put(11726, 0.5).put(11707, 2.5).put(11750, 1.5).put(11751, 1.5).put(11752, 1.5).put(11746, 0.0).put(11748, 0.0).put(11747, 0.0).put(11749, 0.0).put(11759, 0.0).put(11760, 0.0).put(11753, 2.0).put(11754, 2.0).put(11755, 0.0).put(11756, 2.0).put(11757, 2.0).put(11758, 0.0).put(11761, 2.5).put(11763, 2.5).put(11762, 2.5).put(11764, 2.5).build();
    private static final ImmutableSet<Integer> P2_WARDENS = ImmutableSet.of(Integer.valueOf(11753), Integer.valueOf(11754), Integer.valueOf(11755), Integer.valueOf(11756), Integer.valueOf(11757), Integer.valueOf(11758), new Integer[0]);
    private static final ImmutableSet<Integer> MVP_ITEMS = ImmutableSet.of(Integer.valueOf(27219), Integer.valueOf(27214), Integer.valueOf(27221), Integer.valueOf(27223));
    private static final ImmutableSet<Integer> WARDEN_HITSPLAT_TYPES = ImmutableSet.of(Integer.valueOf(53), Integer.valueOf(55));
    private final EventBus eventBus;
    private final Client client;
    private final TombsOfAmascutConfig config;
    private final PartyPointsTracker partyPointsTracker;
    private final RaidStateTracker raidStateTracker;
    private int personalRoomPoints;
    private int personalTotalPoints;
    private int nonPartyPoints;
    private final List<Integer> seenMvpItems = new ArrayList<Integer>(4);
    private int teamSize;
    private int raidLevel;
    private int wardenDowns;

    @Override
    public boolean isEnabled(TombsOfAmascutConfig config, RaidState raidState) {
        return raidState.isInRaid();
    }

    @Override
    public void startUp() {
        this.eventBus.register(this);
        this.reset();
    }

    @Override
    public void shutDown() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public void onGameTick(GameTick e) {
        this.raidLevel = this.client.getVarbitValue(14380);
    }

    @Subscribe
    public void onRaidStateChanged(RaidStateChanged e) {
        this.teamSize = e.getNewState().getPlayerCount();
        if (e.getPreviousState() == null || e.getPreviousState().getCurrentRoom() == null) {
            return;
        }
        switch (e.getPreviousState().getCurrentRoom()) {
            case SCABARAS: {
                this.personalTotalPoints += 300;
                this.nonPartyPoints += 300;
                this.updatePersonalPartyPoints(false);
                break;
            }
            case APMEKEN: {
                this.personalTotalPoints += 450;
                this.nonPartyPoints += 300;
                this.updatePersonalPartyPoints(false);
                break;
            }
            case CRONDIS: {
                this.personalTotalPoints += 400;
                this.nonPartyPoints += 300;
                this.updatePersonalPartyPoints(false);
                break;
            }
            case HET: 
            case WARDENS: {
                this.nonPartyPoints += 300;
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        if (e.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        if (e.getMessage().startsWith(START_MESSAGE)) {
            this.reset();
        } else if (e.getMessage().startsWith(DEATH_MESSAGE)) {
            this.personalTotalPoints -= (int)Math.max(0.2 * (double)this.personalTotalPoints, 1000.0);
            if (this.personalTotalPoints < 0) {
                this.personalTotalPoints = 0;
            }
            this.updatePersonalPartyPoints(false);
        } else if (e.getMessage().startsWith(ROOM_FAIL_MESSAGE)) {
            this.wardenDowns = 0;
            this.personalRoomPoints = 0;
            this.updatePersonalPartyPoints(false);
        } else if (e.getMessage().startsWith(ROOM_FINISH_MESSAGE)) {
            this.personalTotalPoints = Math.min(69000, this.personalTotalPoints + this.personalRoomPoints);
            this.personalRoomPoints = 0;
            boolean wardens = e.getMessage().contains("Wardens");
            this.updatePersonalPartyPoints(wardens);
            if (wardens && this.config.pointsTrackerPostRaidMessage()) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", this.buildPointsMessage(), "", false);
            }
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied e) {
        if (e.getHitsplat().getAmount() < 1 || !(e.getActor() instanceof NPC)) {
            return;
        }
        NPC target = (NPC)e.getActor();
        log.debug("Hitsplat type {} damage {} on {}", e.getHitsplat().getHitsplatType(), e.getHitsplat().getAmount(), target.getId());
        if (P2_WARDENS.contains(target.getId()) && this.wardenDowns > 3) {
            return;
        }
        double factor = DAMAGE_POINTS_FACTORS.getOrDefault(target.getId(), 1.0);
        if (e.getHitsplat().isMine() || WARDEN_HITSPLAT_TYPES.contains(e.getHitsplat().getHitsplatType())) {
            this.personalRoomPoints = (int)Math.min(20000.0, (double)this.personalRoomPoints + (double)e.getHitsplat().getAmount() * factor);
            this.updatePersonalPartyPoints(false);
        }
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned e) {
        if (MVP_ITEMS.contains(e.getItem().getId()) && !this.seenMvpItems.contains(e.getItem().getId())) {
            this.personalTotalPoints += 300 * this.teamSize;
            this.seenMvpItems.add(e.getItem().getId());
            this.updatePersonalPartyPoints(false);
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged e) {
        if (!(e.getActor() instanceof NPC) || !P2_WARDENS.contains(((NPC)e.getActor()).getId())) {
            return;
        }
        if (e.getActor().getAnimation() == 9670) {
            ++this.wardenDowns;
        }
    }

    public int getPersonalTotalPoints() {
        return this.personalTotalPoints + this.personalRoomPoints - 5000;
    }

    public double getPersonalPercent() {
        if (this.raidStateTracker.getPlayerCount() == 1) {
            return 1.0;
        }
        return (double)this.getPersonalTotalPoints() / (double)this.getTotalPoints();
    }

    public int getTotalPoints() {
        if (this.partyPointsTracker.isInParty()) {
            return this.partyPointsTracker.getTotalPartyPoints();
        }
        return this.getPersonalTotalPoints() + this.nonPartyPoints;
    }

    public double getUniqueChance() {
        return UniqueChanceCalculator.getUniqueChance(this.raidLevel, this.getTotalPoints());
    }

    public double getPetChance() {
        return UniqueChanceCalculator.getPetChance(this.raidLevel, this.getTotalPoints());
    }

    private void reset() {
        this.personalTotalPoints = 5000;
        this.personalRoomPoints = 0;
        this.nonPartyPoints = 0;
        this.teamSize = 0;
        this.raidLevel = -1;
        this.wardenDowns = 0;
        this.seenMvpItems.clear();
        this.partyPointsTracker.clearPartyPointsMap();
        this.updatePersonalPartyPoints(true);
    }

    private void updatePersonalPartyPoints(boolean sendNow) {
        int points = Math.min(69000, this.personalTotalPoints + this.personalRoomPoints) - 5000;
        if (sendNow) {
            this.partyPointsTracker.sendPointsUpdate(points);
        } else {
            this.partyPointsTracker.schedulePointsUpdate(points);
        }
    }

    private String buildPointsMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Total points: ");
        sb.append(ColorUtil.wrapWithColorTag(POINTS_FORMAT.format(this.getTotalPoints()), Color.red));
        sb.append(", Personal points: ");
        sb.append(ColorUtil.wrapWithColorTag(POINTS_FORMAT.format(this.getPersonalTotalPoints()), Color.red));
        sb.append(" (");
        sb.append(ColorUtil.wrapWithColorTag(PERCENT_FORMAT.format(this.getPersonalPercent()), Color.red));
        sb.append(")");
        return sb.toString();
    }

    @Inject
    public PointsTracker(EventBus eventBus, Client client, TombsOfAmascutConfig config, PartyPointsTracker partyPointsTracker, RaidStateTracker raidStateTracker) {
        this.eventBus = eventBus;
        this.client = client;
        this.config = config;
        this.partyPointsTracker = partyPointsTracker;
        this.raidStateTracker = raidStateTracker;
    }

    public int getPersonalRoomPoints() {
        return this.personalRoomPoints;
    }
}

