/*
 * Decompiled with CFR 0.152.
 */
package com.duckblade.osrs.toa.features.hporbs;

import com.google.common.base.Strings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.TextComponent;

public class DoubleHpBarComponent
implements LayoutableRenderableEntity {
    private double value1;
    private String centerLabel1;
    private double value2;
    private String centerLabel2;
    private Color foregroundColor = new Color(0, 146, 54, 230);
    private Color backgroundColor = new Color(102, 15, 16, 230);
    private Color fontColor = Color.WHITE;
    private Point preferredLocation = new Point();
    private Dimension preferredSize = new Dimension(129, 16);
    private int gap = 3;
    private final Rectangle bounds = new Rectangle();

    @Override
    public Dimension render(Graphics2D graphics) {
        int baseX = this.preferredLocation.x;
        int baseY = this.preferredLocation.y;
        int totalWidth = this.preferredSize.width;
        int totalHeight = Math.max(this.preferredSize.height, 16);
        int barWidth = (totalWidth - this.gap) / 2;
        this.drawBar(graphics, this.centerLabel1, this.value1, baseX, baseY, barWidth, totalHeight);
        if (!Strings.isNullOrEmpty(this.centerLabel2)) {
            this.drawBar(graphics, this.centerLabel2, this.value2, baseX + barWidth + this.gap, baseY, barWidth, totalHeight);
        }
        Dimension dimension = new Dimension(totalWidth, totalHeight);
        this.bounds.setLocation(this.preferredLocation);
        this.bounds.setSize(dimension);
        return dimension;
    }

    private void drawBar(Graphics2D graphics, String name, double value, int baseX, int baseY, int width, int height) {
        FontMetrics metrics = graphics.getFontMetrics();
        if (metrics.stringWidth(name) > width) {
            name = DoubleHpBarComponent.trimmedName(metrics, name, width);
        }
        int progressFill = (int)((double)width * Math.min(1.0, value));
        int progressTextX = baseX + (width - metrics.stringWidth(name)) / 2;
        int progressTextY = baseY + (height - metrics.getHeight()) / 2 + metrics.getHeight();
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(baseX, baseY, width, height);
        graphics.setColor(this.foregroundColor);
        graphics.fillRect(baseX, baseY, progressFill, height);
        TextComponent textComponent1 = new TextComponent();
        textComponent1.setPosition(new Point(progressTextX, progressTextY));
        textComponent1.setColor(this.fontColor);
        textComponent1.setText(name);
        textComponent1.render(graphics);
    }

    private static String trimmedName(FontMetrics metrics, String name, int maxWidth) {
        String runningName = name;
        while (metrics.stringWidth(runningName + "...") > maxWidth) {
            runningName = runningName.substring(0, runningName.length() - 1);
        }
        return runningName + "...";
    }

    public void setValue1(double value1) {
        this.value1 = value1;
    }

    public void setCenterLabel1(String centerLabel1) {
        this.centerLabel1 = centerLabel1;
    }

    public void setValue2(double value2) {
        this.value2 = value2;
    }

    public void setCenterLabel2(String centerLabel2) {
        this.centerLabel2 = centerLabel2;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    @Override
    public void setPreferredLocation(Point preferredLocation) {
        this.preferredLocation = preferredLocation;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.preferredSize = preferredSize;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }
}

