/*
 * Decompiled with CFR 0.152.
 */
package ca.gauntlet.module.overlay;

import ca.gauntlet.TheGauntletConfig;
import ca.gauntlet.TheGauntletPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.time.Instant;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.MenuAction;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

@Singleton
public final class TimerOverlay
extends OverlayPanel {
    private final TheGauntletConfig config;
    private final ChatMessageManager chatMessageManager;
    private final PanelComponent timerComponent;
    private final LineComponent prepTimeComponent;
    private final LineComponent totalTimeComponent;
    private long timeGauntletStart;
    private long timeHunllefStart;
    private long lastElapsed;

    @Inject
    TimerOverlay(TheGauntletPlugin plugin, TheGauntletConfig config, ChatMessageManager chatMessageManager) {
        super(plugin);
        this.config = config;
        this.chatMessageManager = chatMessageManager;
        this.timerComponent = new PanelComponent();
        this.timerComponent.setBorder(new Rectangle(2, 1, 4, 0));
        this.timerComponent.setBackgroundColor(null);
        this.panelComponent.setBorder(new Rectangle(2, 2, 2, 2));
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Gauntlet Timer").build());
        this.panelComponent.getChildren().add(this.timerComponent);
        this.prepTimeComponent = LineComponent.builder().left("Preparation:").right("").build();
        this.totalTimeComponent = LineComponent.builder().left("Total:").right("").build();
        this.timeGauntletStart = -1L;
        this.timeHunllefStart = -1L;
        this.lastElapsed = 0L;
        this.setClearChildren(false);
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "The Gauntlet timer"));
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setMovable(true);
        this.setSnappable(true);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    @Override
    public Dimension render(Graphics2D graphics2D) {
        if (!this.config.timerOverlay() || this.timeGauntletStart == -1L) {
            return null;
        }
        graphics2D.setFont(FontManager.getRunescapeSmallFont());
        LineComponent lineComponent = this.timeHunllefStart == -1L ? this.prepTimeComponent : this.totalTimeComponent;
        long elapsed = Instant.now().getEpochSecond() - this.timeGauntletStart;
        if (elapsed != this.lastElapsed) {
            lineComponent.setRight(TimerOverlay.formatElapsedTime(elapsed));
            this.lastElapsed = elapsed;
        }
        return super.render(graphics2D);
    }

    public void reset() {
        this.timeGauntletStart = -1L;
        this.timeHunllefStart = -1L;
        this.lastElapsed = 0L;
        this.prepTimeComponent.setRight("");
        this.totalTimeComponent.setRight("");
        this.timerComponent.getChildren().clear();
    }

    public void setGauntletStart() {
        this.timeGauntletStart = Instant.now().getEpochSecond();
        this.prepTimeComponent.setLeftColor(Color.WHITE);
        this.prepTimeComponent.setRightColor(Color.WHITE);
        this.timerComponent.getChildren().clear();
        this.timerComponent.getChildren().add(this.prepTimeComponent);
    }

    public void setHunllefStart() {
        this.timeHunllefStart = Instant.now().getEpochSecond();
        this.prepTimeComponent.setLeftColor(Color.LIGHT_GRAY);
        this.prepTimeComponent.setRightColor(Color.LIGHT_GRAY);
        this.timerComponent.getChildren().clear();
        this.timerComponent.getChildren().add(this.prepTimeComponent);
        this.timerComponent.getChildren().add(this.totalTimeComponent);
    }

    public void onPlayerDeath() {
        if (!this.config.timerChatMessage()) {
            return;
        }
        this.printTime();
        this.reset();
    }

    private void printTime() {
        if (this.timeGauntletStart == -1L || this.timeHunllefStart == -1L) {
            return;
        }
        long current = Instant.now().getEpochSecond();
        String elapsedPrepTime = TimerOverlay.formatElapsedTime(this.timeHunllefStart, this.timeGauntletStart);
        String elapsedBossTime = TimerOverlay.formatElapsedTime(current, this.timeHunllefStart);
        String elapsedTotalTime = TimerOverlay.formatElapsedTime(current, this.timeGauntletStart);
        ChatMessageBuilder chatMessageBuilder = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Preparation time: ").append(ChatColorType.HIGHLIGHT).append(elapsedPrepTime).append(ChatColorType.NORMAL).append(". Hunllef time: ").append(ChatColorType.HIGHLIGHT).append(elapsedBossTime).append(ChatColorType.NORMAL).append(". Total time: ").append(ChatColorType.HIGHLIGHT).append(elapsedTotalTime).append(ChatColorType.NORMAL).append(".");
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessageBuilder.build()).build());
    }

    private static String formatElapsedTime(long end, long start) {
        return TimerOverlay.formatElapsedTime(end - start);
    }

    private static String formatElapsedTime(long elapsed) {
        long minutes = elapsed % 3600L / 60L;
        long seconds = elapsed % 60L;
        return String.format("%01d:%02d", minutes, seconds);
    }
}

